/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcWinRuleRatioPackagePurlistValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        String ratioType;
        DynamicObject billObj = context.getBillObj();
        Long projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        String fieldName = "ratiotype";
        if (billObj.getDataEntityType().getName().equals("src_ratiotypechg")) {
            projectId = billObj.getDynamicObject("projectf7").getLong("id");
            fieldName = "newratiotype";
        }
        if ("1".equals(ratioType = PdsCommonUtils.object2String((Object)billObj.get(fieldName), (String)"1")) || "9".equals(ratioType) || "2".equals(ratioType)) {
            return;
        }
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        StringBuilder sb = new StringBuilder();
        if ("3".equals(ratioType)) {
            Set idSet = rows.stream().map(e -> e.getLong("package.id")).collect(Collectors.toSet());
            qfilter.and("id", "not in", idSet);
            DynamicObjectCollection packageRows = QueryServiceHelper.query((String)"src_packagef7", (String)"packagename", (QFilter[])qfilter.toArray());
            for (DynamicObject packageRow : packageRows) {
                sb.append(String.format(ResManager.loadKDString((String)"\u6807\u6bb5\uff1a%1$s", (String)"SrcWinRuleRatioPackagePurlistValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), packageRow.getString("packagename"))).append(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4efd\u989d\u5206\u914d\u6bd4\u7387\u3002", (String)"SrcWinRuleRatioPackagePurlistValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0])).append("\n");
            }
        } else {
            Set idSet = rows.stream().map(e -> e.getLong("purlist.id")).collect(Collectors.toSet());
            qfilter.and("id", "not in", idSet);
            qfilter.and("billtype", "=", (Object)Character.valueOf('1'));
            DynamicObjectCollection purlistRows = QueryServiceHelper.query((String)"src_purlistf7", (String)"materialnane", (QFilter[])qfilter.toArray());
            for (DynamicObject purlistRow : purlistRows) {
                sb.append(String.format(ResManager.loadKDString((String)"\u6807\u7684\uff1a%1$s", (String)"SrcWinRuleRatioPackagePurlistValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), purlistRow.getString("materialnane"))).append(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4efd\u989d\u5206\u914d\u6bd4\u7387\u3002", (String)"SrcWinRuleRatioPackagePurlistValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0])).append("\n");
            }
        }
        if (sb.length() > 0) {
            context.setMessage(sb.toString());
            context.setSucced(false);
        }
    }
}

