/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.src.common.util.SrcWinruleUtils;

public class SrcWinSupplierQtyValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        StringBuilder message = new StringBuilder();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        Map winruleSupQtyMap = SrcWinruleUtils.getWinruleWinerQtyMap((long)projectId);
        Map decisionSupQtyMap = SrcWinruleUtils.getDecisionWinerQtyMap((long)projectId);
        String compareType = (String)ExtParameterUtils.getExtParameterValueByNumber((String)"pds_validatorconfig", (String)"SYS210", (String)"winSupplierQty", (Object)"=");
        for (Map.Entry entry : decisionSupQtyMap.entrySet()) {
            int decisionSupQty;
            String[] keys = ((String)entry.getKey()).split("\\|");
            long packageId = PdsCommonUtils.object2Long((Object)keys[0]);
            long purlistId = PdsCommonUtils.object2Long((Object)keys[1]);
            String packageName = keys[2];
            String materialName = keys[3];
            int winRuleSupQty = this.getWinerQty(winruleSupQtyMap, projectId, packageId, purlistId);
            if (this.isVerifyOk(compareType, winRuleSupQty, decisionSupQty = ((Integer)entry.getValue()).intValue())) continue;
            if (!"ByItem".equals(packageName)) {
                message.append(packageName).append("--");
            }
            message.append(materialName).append(": ");
            message.append(String.format(ResManager.loadKDString((String)"\u5b9a\u6807\u7684\u4e2d\u6807\u4f9b\u5e94\u5546\u6570\u91cf(%1$s), \u4e0d\u7b26\u5408\u4e2d\u6807\u539f\u5219\u7684\u4e2d\u6807\u4f9b\u5e94\u5546\u6570\u91cf(%2$s)\u3002", (String)"SrcWinSupplierQtyValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), decisionSupQty, winRuleSupQty)).append("\n");
        }
        if (message.length() > 0) {
            context.setMessage(message.toString());
            context.setSucced(false);
        }
    }

    private int getWinerQty(Map<Long, Integer> winruleSupQtyMap, long projectId, long packageId, long purlistId) {
        if (null != winruleSupQtyMap.get(purlistId) && winruleSupQtyMap.get(purlistId) > 0) {
            return winruleSupQtyMap.get(purlistId);
        }
        if (null != winruleSupQtyMap.get(packageId) && winruleSupQtyMap.get(packageId) > 0) {
            return winruleSupQtyMap.get(packageId);
        }
        return winruleSupQtyMap.get(projectId);
    }

    private boolean isVerifyOk(String compareType, int winRuleSupQty, int decisionSupQty) {
        if (winRuleSupQty == 0) {
            return true;
        }
        if (decisionSupQty == 0) {
            return false;
        }
        switch (compareType) {
            case "=": {
                return decisionSupQty == winRuleSupQty;
            }
            case "<=": {
                return decisionSupQty <= winRuleSupQty;
            }
            case "<": {
                return decisionSupQty < winRuleSupQty;
            }
            case ">": {
                return decisionSupQty > winRuleSupQty;
            }
            case ">=": {
                return decisionSupQty >= winRuleSupQty;
            }
        }
        return true;
    }
}

