/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.attach;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.attach.IPdsAttachHandler;
import kd.scm.pds.common.attach.PdsAttachContext;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsReportUtils;

public class SrcPublishNoticeAttachHandler
implements IPdsAttachHandler {
    private static final long serialVersionUID = 1L;

    public List<Map<String, Object>> getAttachments(PdsAttachContext context) {
        String entityName = "sou_notice";
        List<String> bizTypes = Arrays.asList("2", "C", "D");
        List<Map<String, Object>> allAttachMaps = this.getNoticeAttachments(context, entityName, bizTypes);
        AttachmentUtils.setAttachmentType(allAttachMaps, (String)ResManager.loadKDString((String)"\u62db\u6807\u516c\u544a", (String)"SrcPublishNoticeAttachHandler_0", (String)"scm-src-common", (Object[])new Object[0]));
        return allAttachMaps;
    }

    public List<Map<String, Object>> getNoticeAttachments(PdsAttachContext context, String entityName, List<String> bizTypes) {
        List prtAttachMaps;
        ArrayList<Map<String, Object>> allAttachMaps = new ArrayList<Map<String, Object>>();
        List<Long> billIds = this.getNoticeBillIds(entityName, context.getBillId(), bizTypes);
        List<Map<String, Object>> attachMaps = this.getNoticeAttachments(entityName, billIds);
        if (null != attachMaps && attachMaps.size() > 0) {
            allAttachMaps.addAll(attachMaps);
        }
        if (null != (prtAttachMaps = PdsReportUtils.getPrintAttachments((String)entityName, billIds, null, null))) {
            allAttachMaps.addAll(prtAttachMaps);
        }
        AttachmentUtils.sortAttachment(allAttachMaps, (String)"name");
        return allAttachMaps;
    }

    private List<Map<String, Object>> getNoticeAttachments(String entityName, List<Long> billIds) {
        ArrayList<Map<String, Object>> noticAttaments = new ArrayList<Map<String, Object>>();
        if (null != billIds && billIds.size() > 0) {
            for (long billId : billIds) {
                List attachs = AttachmentServiceHelper.getAttachments((String)entityName, (Object)billId, (String)"attachmentpanel", (boolean)false);
                noticAttaments.addAll(attachs);
            }
        }
        return noticAttaments;
    }

    private List<Long> getNoticeBillIds(String entityName, long projectId, List<String> bizTypes) {
        QFilter qfilter = new QFilter("srcbillid", "=", (Object)projectId);
        qfilter.and("biztype", "in", bizTypes);
        qfilter.and("billstatus", "in", (Object)BillStatusEnum.AUDIT.getVal());
        if (bizTypes.contains("2")) {
            qfilter.and(ExtFilterUtils.getStringFilter((String)"pentitykey", (Set)PdsCommonUtils.buildSet((String[])new String[]{"src_project", "src_publishnotice"})));
        }
        if (bizTypes.contains("5")) {
            qfilter.and(ExtFilterUtils.getStringFilter((String)"pentitykey", (Set)PdsCommonUtils.buildSet((String[])new String[]{"src_decision", "src_publishwinnotice"})));
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qfilter.toArray());
        List<Long> billIds = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        return billIds;
    }
}

