/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.validator.SrcCommonValidatorHelper;
import kd.scm.src.common.bidopen.ISrcBidOpenAfterHandler;
import kd.scm.src.common.bidopen.ISrcBidOpenHandler;
import kd.scm.src.common.bidopen.ISrcBidOpenPrepare;
import kd.scm.src.common.bidopen.SrcBidOpenContext;
import kd.scm.src.common.bidopen.SrcBidOpenFactory;
import kd.scm.src.common.bidopen.SrcBidOpenUtils;
import kd.scm.src.common.bidopen.applyopen.ISrcCreateBidOpenApply;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidAutoOpenByOpenType;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenAptBtnVisible;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenAptHandle;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenBizHandle;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenButtonVisible;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenConfirmHandle;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenHideSupplierName;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenInitPage;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenOldDataDelete;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenPkgOpenHandle;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenPushBtnVisible;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenSaveSupOpenData;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenTecHandle;
import kd.scm.src.common.util.SrcAppCache;

public class SrcBidOpenFacade {
    public static Map<String, Object> openBidDoc(String openType, QFilter tecFilter, QFilter bizFilter, QFilter aptFilter) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setOpenType(openType);
        context.setTecFilter(tecFilter);
        context.setBizFilter(bizFilter);
        context.setAptFilter(aptFilter);
        List<ISrcBidOpenHandler> handlers = SrcBidOpenFactory.getBiddocOpenHandlerInstances();
        for (ISrcBidOpenHandler handler : handlers) {
            handler.process(context);
        }
        return context.getResultMap();
    }

    public static Map<String, Object> openPurlist(QFilter purlistFilter) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setPurlistFilter(purlistFilter);
        List<ISrcBidOpenHandler> handlers = SrcBidOpenFactory.getPurlistOpenHandlerInstances();
        for (ISrcBidOpenHandler handler : handlers) {
            handler.process(context);
        }
        return context.getResultMap();
    }

    public static Map<String, Object> setPackageOpenStatus(DynamicObject billObj, QFilter packageFilter) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setBillObj(billObj);
        context.setPackageFilter(packageFilter);
        List<ISrcBidOpenHandler> handlers = SrcBidOpenFactory.getPackageStatusHandlerInstances();
        for (ISrcBidOpenHandler handler : handlers) {
            handler.process(context);
        }
        return context.getResultMap();
    }

    public static Map<String, Object> setPackageAptOpenStatus(QFilter packageFilter) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setPackageFilter(packageFilter);
        List<ISrcBidOpenHandler> handlers = SrcBidOpenFactory.getPackageAptStatusHandlerInstances();
        for (ISrcBidOpenHandler handler : handlers) {
            handler.process(context);
        }
        return context.getResultMap();
    }

    public static Map<String, Object> setProjectOpenStatus(long projectId) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setProjectId(projectId);
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)context.getProjectId(), (String)"src_project");
        context.setBillObj(billObj);
        List<ISrcBidOpenAfterHandler> handlers = SrcBidOpenFactory.getProjectStatusHandlerInstances();
        for (ISrcBidOpenAfterHandler handler : handlers) {
            handler.process(context);
        }
        return context.getResultMap();
    }

    public static Map<String, Object> pushScoreTask(IFormView view, DynamicObject billObj, String operation, List<DynamicObject> selectedRowDatas) {
        return SrcBidOpenFacade.pushScoreTask(view, billObj, operation, selectedRowDatas, operation);
    }

    public static Map<String, Object> pushScoreTask(IFormView view, DynamicObject billObj, String operation, List<DynamicObject> selectedRowDatas, String operateKey) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setView(view);
        context.setBillObj(billObj);
        context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)billObj));
        context.setOperation(operation);
        context.setOperateKey(operateKey);
        context.setSelectedRowDatas(selectedRowDatas);
        List<ISrcBidOpenAfterHandler> handlers = SrcBidOpenFactory.getPushScoreTaskHandlerInstances();
        for (ISrcBidOpenAfterHandler handler : handlers) {
            handler.process(context);
        }
        return context.getResultMap();
    }

    public static Map<String, Object> synthCalculate(String entityId, long projectId) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setEntityId(entityId);
        context.setProjectId(projectId);
        List<ISrcBidOpenAfterHandler> handlers = SrcBidOpenFactory.getSynthCalculateHandlerInstances();
        for (ISrcBidOpenAfterHandler handler : handlers) {
            handler.process(context);
        }
        return context.getResultMap();
    }

    public static String bidAutoOpenVerify(DynamicObject billObj) {
        return SrcBidOpenFacade.bidAutoOpenVerify(billObj, "allopen");
    }

    public static String bidAutoOpenVerify(DynamicObject billObj, String openType) {
        String message = SrcCommonValidatorHelper.validate((DynamicObject)billObj, (String)billObj.getDataEntityType().getName(), (String)openType, null, null);
        if (message != null && message.length() > 0) {
            return message;
        }
        return "succed";
    }

    public static Set<Long> getSelectPackageIds(long projectId, String entityId) {
        Set selectPackageIds = null;
        String key = String.valueOf(projectId) + '_' + entityId + '_' + "packageid";
        Object packageListObj = PdsObjectPools.getInstance((String)key);
        if (packageListObj != null) {
            selectPackageIds = (Set)packageListObj;
            PdsObjectPools.removeInstance((String)key);
        }
        if (null == selectPackageIds || selectPackageIds.size() == 0) {
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidopenpackage", (String)"package.id", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)projectId)});
            selectPackageIds = rows.stream().map(e -> e.getLong("package.id")).collect(Collectors.toSet());
        }
        return selectPackageIds;
    }

    public static SrcBidOpenContext getBidOpenTipMessage(DynamicObject billObj) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setBillObj(billObj);
        List<ISrcBidOpenPrepare> handlers = SrcBidOpenFactory.getBidOpenTipMessagePrepareInstances();
        for (ISrcBidOpenPrepare handler : handlers) {
            handler.process(context);
        }
        return context;
    }

    public static void bidOpenCommHandle(SrcBidOpenContext context, String number, String defaultPlugin) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(number, defaultPlugin);
        for (ISrcBidOpenHandler handler : handlers) {
            handler.process(context);
        }
    }

    public static void bidOpenCommHandle(IFormView view, String number, String defaultPlugin) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setView(view);
        SrcBidOpenFacade.bidOpenCommHandle(context, number, defaultPlugin);
    }

    public static void setOpenButtonVisible(IFormView view, String button) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setView(view);
        context.setButton(button);
        SrcBidOpenFacade.bidOpenCommHandle(context, SrcBidOpenButtonVisible.class.getSimpleName(), SrcBidOpenButtonVisible.class.getName());
    }

    public static void setPushButtonVisible(IFormView view) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setView(view);
        SrcBidOpenFacade.bidOpenCommHandle(context, SrcBidOpenPushBtnVisible.class.getSimpleName(), SrcBidOpenPushBtnVisible.class.getName());
    }

    public static void setAptOpenButtonVisible(IFormView view) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setView(view);
        SrcBidOpenFacade.bidOpenCommHandle(context, SrcBidOpenAptBtnVisible.class.getSimpleName(), SrcBidOpenAptBtnVisible.class.getName());
    }

    public static void handleTecBid(SrcBidOpenContext context, String opentype, DynamicObject row, List<Long> tecList, StringBuilder sb, DynamicObject[] packageObjs, List<Long> supList) {
        SrcBidOpenFacade.setContextValue(context, opentype, row, tecList, Collections.emptyList(), Collections.emptyList(), sb, packageObjs, supList);
        SrcBidOpenFacade.bidOpenCommHandle(context, SrcBidOpenTecHandle.class.getSimpleName(), SrcBidOpenTecHandle.class.getName());
    }

    public static void handleBizBid(SrcBidOpenContext context, String opentype, DynamicObject row, List<Long> bizList, StringBuilder sb, DynamicObject[] packageObjs, List<Long> supList) {
        SrcBidOpenFacade.setContextValue(context, opentype, row, Collections.emptyList(), bizList, Collections.emptyList(), sb, packageObjs, supList);
        SrcBidOpenFacade.bidOpenCommHandle(context, SrcBidOpenBizHandle.class.getSimpleName(), SrcBidOpenBizHandle.class.getName());
    }

    public static void handleAptBid(SrcBidOpenContext context, String opentype, DynamicObject row, List<Long> aptList, StringBuilder sb, DynamicObject[] packageObjs, List<Long> supList) {
        SrcBidOpenFacade.setContextValue(context, opentype, row, Collections.emptyList(), Collections.emptyList(), aptList, sb, packageObjs, supList);
        SrcBidOpenFacade.bidOpenCommHandle(context, SrcBidOpenAptHandle.class.getSimpleName(), SrcBidOpenAptHandle.class.getName());
    }

    public static void setContextValue(SrcBidOpenContext context, String opentype, DynamicObject row, List<Long> tecList, List<Long> bizList, List<Long> aptList, StringBuilder sb, DynamicObject[] packageObjs, List<Long> supList) {
        context.setOpenType(opentype);
        context.setRow(row);
        context.setSb(sb);
        context.setTecList(tecList);
        context.setBizList(bizList);
        context.setAptList(aptList);
        context.setSupList(supList);
        context.setPackageObjs(packageObjs);
    }

    public static void initBidOpenPage(IFormView view) {
        SrcBidOpenFacade.bidOpenCommHandle(view, SrcBidOpenInitPage.class.getSimpleName(), SrcBidOpenInitPage.class.getName());
    }

    public static void bidOpenHandle(IFormView view, String operateKey) {
        String openControlType;
        switch (openControlType = SrcBidOpenFacade.getOpenControlType(view.getModel().getDataEntity(), operateKey)) {
            case "1": {
                SrcBidOpenFacade.directBidOpen(view, operateKey);
                break;
            }
            case "2": 
            case "3": {
                SrcBidOpenFacade.applyBidOpen(view, operateKey, openControlType);
                break;
            }
            case "4": {
                break;
            }
        }
    }

    public static void directBidOpen(IFormView view, String operateKey) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setView(view);
        context.setOperateKey(operateKey);
        SrcBidOpenFacade.bidOpenCommHandle(context, SrcBidOpenPkgOpenHandle.class.getSimpleName(), SrcBidOpenPkgOpenHandle.class.getName());
    }

    public static void applyBidOpen(IFormView view, String operateKey, String openControlType) {
        DynamicObject applyObj = SrcBidOpenFacade.getBidOpenApplyObj(view.getModel().getDataEntity(), operateKey);
        if (null == applyObj) {
            applyObj = SrcBidOpenFacade.createBidOpenApplyObj(view.getModel().getDataEntity(), operateKey, null);
            PdsCommonUtils.saveDynamicObjects((DynamicObject)applyObj);
            if ("3".equals(openControlType)) {
                PdsCommonUtils.doOperation((DynamicObject)applyObj, (String)"submit");
            }
        }
        OpenFormUtil.openBillPage((IFormView)view, (String)"src_bidopenapply", (Object)applyObj.getLong("id"), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
    }

    public static void confirmHandle(IFormView view) {
        SrcBidOpenFacade.bidOpenCommHandle(view, SrcBidOpenConfirmHandle.class.getSimpleName(), SrcBidOpenConfirmHandle.class.getName());
    }

    public static void pushScoreTask(IFormView view, String operateKey, List<DynamicObject> selectedRowDatas) {
        String key = String.valueOf(PdsCommonUtils.object2Long((Object)view.getModel().getDataEntity().getPkValue())) + '_' + view.getEntityId() + '_' + "packageid";
        PdsObjectPools.putInstance((String)key, SrcBidOpenUtils.getSelectPackageIds(view));
        Map<String, Object> resultMap = SrcBidOpenFacade.pushScoreTask(view, view.getModel().getDataEntity(), operateKey, selectedRowDatas);
        Object succed = resultMap.get("succed");
        if (null != succed && ((Boolean)succed).booleanValue()) {
            view.invokeOperation("refresh");
            view.showMessage(ResManager.loadKDString((String)"\u4e0b\u8fbe\u8bc4\u6807\u4efb\u52a1\u6210\u529f\u3002", (String)"SrcBidOpenFacade_0", (String)"scm-src-common", (Object[])new Object[0]));
        } else {
            Object message = resultMap.get("message");
            view.showMessage(ResManager.loadKDString((String)"\u4e0b\u8fbe\u8bc4\u6807\u4efb\u52a1\u5931\u8d25\u3002", (String)"SrcBidOpenFacade_1", (String)"scm-src-common", (Object[])new Object[0]), String.valueOf(message), MessageTypes.Default);
        }
    }

    public static void rePushScoreTask(IFormView view) {
        SrcBidOpenFacade.bidOpenCommHandle(view, SrcBidOpenOldDataDelete.class.getSimpleName(), SrcBidOpenOldDataDelete.class.getName());
        SrcBidOpenFacade.pushScoreTask(view, "allopen", Collections.emptyList());
    }

    public static Map<String, String> getBidOpenNameMap(DynamicObject projectObj) {
        HashMap<String, String> bidOpenNameMap = new HashMap<String, String>(2);
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)projectObj.getDynamicObject("srctype"));
        boolean isOpenBySupplier = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isopenbysupplier", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)projectObj)));
        if (isOpenBySupplier) {
            bidOpenNameMap.put("src_bidopen_open", "src_supplier_open");
            bidOpenNameMap.put("src_bidopenpackage", "src_supplieropen");
        } else {
            bidOpenNameMap.put("src_bidopen_open", "src_bidopen_open");
            bidOpenNameMap.put("src_bidopenpackage", "src_bidopenpackage");
        }
        return bidOpenNameMap;
    }

    public static void updatePackageOpenStatus(long projectId, Set<Long> packageIds, String openType) {
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        qfilter.and("package", "in", packageIds);
        switch (openType) {
            case "isaptopen": 
            case "istecopen": 
            case "isbizopen": {
                qfilter.and(openType, "=", (Object)"0");
                break;
            }
            case "isallopen": {
                qfilter.and(new QFilter("istecopen", "=", (Object)"0").or("isbizopen", "=", (Object)"0"));
                break;
            }
        }
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidopenpackage", (boolean)false);
        DynamicObject[] packageObjs = BusinessDataServiceHelper.load((String)"src_bidopenpackage", (String)selectFields, (QFilter[])qfilter.toArray());
        if (packageObjs.length == 0) {
            return;
        }
        ArrayList<DynamicObject> pacakgeList = new ArrayList<DynamicObject>(packageObjs.length);
        for (DynamicObject packageObj : packageObjs) {
            if (!SrcBidOpenFacade.isAllSupplierOpen(projectId, packageObj.getLong("package.id"), openType)) continue;
            switch (openType) {
                case "isaptopen": {
                    SrcBidOpenFacade.updateAptOpenStatus(packageObj);
                    break;
                }
                case "istecopen": {
                    SrcBidOpenFacade.updateTecOpenStatus(packageObj);
                    break;
                }
                case "isbizopen": {
                    SrcBidOpenFacade.updateBizOpenStatus(packageObj);
                    break;
                }
                case "isallopen": {
                    SrcBidOpenFacade.updateTecOpenStatus(packageObj);
                    SrcBidOpenFacade.updateBizOpenStatus(packageObj);
                    break;
                }
            }
            pacakgeList.add(packageObj);
        }
        PdsCommonUtils.saveDynamicObjects(pacakgeList);
    }

    public static boolean isAllSupplierOpen(long projectId, long packageId, String openType) {
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        if (packageId > 0L) {
            qfilter.and("package", "=", (Object)packageId);
        }
        SrcBidOpenFacade.addSupplierOpenFilter(qfilter, true);
        if ("isallopen".equals(openType)) {
            qfilter.and(new QFilter("istecopen", "=", (Object)"0").or("isbizopen", "=", (Object)"0"));
        } else {
            qfilter.and(openType, "=", (Object)"0");
        }
        return !QueryServiceHelper.exists((String)"src_supplieropen", (QFilter[])qfilter.toArray());
    }

    public static void updateTecOpenStatus(DynamicObject obj) {
        obj.set("istecopen", (Object)"1");
        obj.set("tecopendate", (Object)TimeServiceHelper.now());
        obj.set("tecopenuser", (Object)RequestContext.get().getCurrUserId());
    }

    public static void updateBizOpenStatus(DynamicObject obj) {
        obj.set("isbizopen", (Object)"1");
        obj.set("bizopendate", (Object)TimeServiceHelper.now());
        obj.set("bizopenuser", (Object)RequestContext.get().getCurrUserId());
    }

    public static void updateAptOpenStatus(DynamicObject obj) {
        obj.set("isaptopen", (Object)"1");
        obj.set("aptopendate", (Object)TimeServiceHelper.now());
        obj.set("aptopenuser", (Object)RequestContext.get().getCurrUserId());
    }

    public static void saveSupOpenData(IFormView view) {
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity().getDynamicObject("srctype"));
        boolean isOpenBySupplier = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isopenbysupplier", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity())));
        if (!isOpenBySupplier) {
            String compPageId = SrcAppCache.get("src_bidopen_open", String.class, view);
            IFormView compView = view.getView(compPageId);
            if (Objects.isNull(compView) || null == compView.getModel()) {
                return;
            }
            PdsCommonUtils.saveDynamicObjects((DynamicObject)compView.getModel().getDataEntity(true));
            return;
        }
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcBidOpenSaveSupOpenData.class.getSimpleName(), SrcBidOpenSaveSupOpenData.class.getName());
        for (SrcBidOpenSaveSupOpenData handler : handlers) {
            handler.saveSupOpenData(view);
        }
    }

    public static long getMaxOpenRank(long projectId) {
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        qfilter.and("rank", ">", (Object)0);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"rank", (QFilter[])qfilter.toArray(), (String)"rank");
        if (rows.size() == 0) {
            return 1L;
        }
        return ((DynamicObject)rows.get(rows.size() - 1)).getInt("rank") + 1;
    }

    public static void addSupplierOpenFilter(QFilter qfilters, boolean isTender) {
        if (isTender) {
            qfilters.and("istender", "=", (Object)"1");
        }
        qfilters.and("isdiscard", "=", (Object)"0");
        qfilters.and("isaptitude", "!=", (Object)"2");
    }

    public static boolean isHideSupplierName(IFormView view, long projectId) {
        SrcBidOpenContext context = new SrcBidOpenContext();
        context.setView(view);
        context.setProjectId(projectId);
        context.setHideSupplierName(false);
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcBidOpenHideSupplierName.class.getSimpleName(), SrcBidOpenHideSupplierName.class.getName());
        for (ISrcBidOpenHandler handler : handlers) {
            handler.process(context);
        }
        return context.isHideSupplierName();
    }

    public static void hideSupplierName(IFormView view, long projectId) {
        boolean isHideSupplierName = SrcBidOpenFacade.isHideSupplierName(view, projectId);
        if (isHideSupplierName) {
            view.setVisible(Boolean.valueOf(false), new String[]{"supplier", "suppliername", "suppliernumber"});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"suppliercode"});
        }
    }

    public static ExtPluginContext autoOpenByOpenType(String entityName, long projectId, String openType, Set<Long> packageIds) {
        ExtPluginContext context = new ExtPluginContext();
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)entityName);
        context.setProjectObj(projectObj);
        context.setProjectId(projectId);
        context.setBillObj(projectObj);
        context.setBillId(projectId);
        context.setOperationKey(openType);
        context.setPackageIds(packageIds);
        ExtPluginFactory.executeExtplugin((String)SrcBidAutoOpenByOpenType.class.getSimpleName(), (ExtPluginContext)context, (boolean)false, (String)SrcBidAutoOpenByOpenType.class.getName());
        return context;
    }

    public static void setPurlistFieldVisible(IFormView view, String entryEntityName, String purlistField, DynamicObject projectObj) {
        if (null == projectObj) {
            view.setVisible(Boolean.valueOf(false), new String[]{purlistField});
            return;
        }
        long sourceFlowId = projectObj.getLong("srctype.id");
        boolean isPushTecByPurlist = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isPushTecScoreTaskByPurlist", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)projectObj)));
        boolean isPushBizByPurlist = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isPushBizScoreTaskByPurlist", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)projectObj)));
        if (isPushTecByPurlist || isPushBizByPurlist) {
            view.setVisible(Boolean.valueOf(true), new String[]{purlistField});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{purlistField});
        }
    }

    public static DynamicObject getBidOpenApplyObj(DynamicObject srcBillObj, String operateKey) {
        QFilter qfilters = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)srcBillObj));
        qfilters.and("srcbilltype", "=", (Object)srcBillObj.getDataEntityType().getName());
        qfilters.and("opentype", "=", (Object)operateKey);
        String selectFields = "id," + DynamicObjectUtil.getSelectfields((String)"src_bidopenapply", (boolean)false);
        return QueryServiceHelper.queryOne((String)"src_bidopenapply", (String)selectFields, (QFilter[])qfilters.toArray());
    }

    public static DynamicObject createBidOpenApplyObj(DynamicObject srcBillObj, String operationKey, Map<Object, Object> paramMap) {
        ExtPluginContext context = new ExtPluginContext();
        context.setBillObj(srcBillObj);
        context.setEntityId(srcBillObj.getDataEntityType().getName());
        if (PdsCommonUtils.getNotProjectBill().contains(context.getEntityId())) {
            context.setProjectObj(srcBillObj.getDynamicObject("project"));
        } else {
            context.setProjectObj(srcBillObj);
        }
        context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj()));
        context.setOperationKey(operationKey);
        context.setParamMap(paramMap);
        DynamicObject targetObj = BusinessDataServiceHelper.newDynamicObject((String)"src_bidopenapply");
        context.setTargetObj(targetObj);
        ExtPluginFactory.executeExtplugin((String)ISrcCreateBidOpenApply.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
        return context.getTargetObj();
    }

    public static String getOpenControlType(DynamicObject srcBillObj, String opentype) {
        DynamicObject applyObj;
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)srcBillObj.getDynamicObject("srctype"));
        String openControlType = PdsCommonUtils.object2String((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"bidOpenControlType", (Object)"1", (long)SrmCommonUtil.getPkValue((DynamicObject)srcBillObj)), (String)"1");
        if (("2".equals(openControlType) || "3".equals(openControlType)) && null != (applyObj = SrcBidOpenFacade.getBidOpenApplyObj(srcBillObj, opentype)) && BillStatusEnum.AUDIT.getVal().equals(applyObj.getString("billstatus"))) {
            return "1";
        }
        return openControlType;
    }

    public static boolean isBidOpenConfig(DynamicObject billObj, String opKey) {
        List compKeys = TemplateUtil.getAllCompKeyListByTplEntry((DynamicObject)billObj);
        boolean isBidOpenConfig = false;
        switch (opKey) {
            case "publish": 
            case "aptopen": {
                isBidOpenConfig = compKeys.contains("src_aptitudeconfig");
                break;
            }
            case "allopen": {
                if ("src_aptitudeaudit2".equals(billObj.getDataEntityType().getName())) {
                    isBidOpenConfig = compKeys.contains("src_aptitudeconfig2");
                    break;
                }
                isBidOpenConfig = compKeys.contains("src_bidopen_config");
                break;
            }
            case "tecopen": 
            case "bizopen": {
                isBidOpenConfig = compKeys.contains("src_bidopen_config");
            }
        }
        return isBidOpenConfig;
    }
}

