/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.bidopencomm;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.ISrcBidOpenHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;

public class SrcBidOpenOldDataDelete
implements ISrcBidOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext context) {
        this.deleteOldData(context);
    }

    protected void deleteOldData(SrcBidOpenContext context) {
        IFormView view = context.getView();
        long projectId = context.getProjectId() > 0L ? context.getProjectId() : SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity());
        this.invalidScoreTask(view, projectId);
        this.deleteScoreSummary(view, projectId);
        this.deleteSuggestion(view, projectId);
        this.deleteScoreResult(view, projectId);
        this.updateAptitudeConfig(view, projectId);
        this.updateTenderSupplier(view, projectId);
    }

    protected void invalidScoreTask(IFormView view, long projectId) {
        QFilter taskFilter = new QFilter("project", "=", (Object)projectId);
        taskFilter.and("indextype.basetype", "!=", (Object)"4");
        taskFilter.and("indextype.basetype", "!=", (Object)"7");
        taskFilter.and("bizstatus", "!=", (Object)"E");
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_scoretask", (String)"bizstatus", (QFilter[])taskFilter.toArray());
        if (rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            row.set("bizstatus", (Object)"E");
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    protected void deleteScoreSummary(IFormView view, long projectId) {
        QFilter tecFilter = new QFilter("billid", "=", (Object)projectId);
        DeleteServiceHelper.delete((String)"src_bidassess_tec", (QFilter[])tecFilter.toArray());
    }

    protected void deleteSuggestion(IFormView view, long projectId) {
        QFilter sugFilter = new QFilter("billid.project", "=", (Object)projectId);
        sugFilter.and("billid.basetype", "!=", (Object)"4");
        sugFilter.and("billid.basetype", "!=", (Object)"7");
        DeleteServiceHelper.delete((String)"src_scoresuggestionf7", (QFilter[])sugFilter.toArray());
        String billId = String.valueOf(projectId) + '_' + "1";
        QFilter qfilters = new QFilter("finterid", "=", (Object)billId);
        qfilters.and("fattachmentpanel", "=", (Object)"attachmentpanel");
        qfilters.and("fbilltype", "=", (Object)"src_scoresuggestion");
        DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])qfilters.toArray());
    }

    protected void deleteScoreResult(IFormView view, long projectId) {
        QFilter bizFilter = new QFilter("billid", "=", (Object)projectId);
        DeleteServiceHelper.delete((String)"src_bidassess_biz", (QFilter[])bizFilter.toArray());
    }

    protected void updateAptitudeConfig(IFormView view, long projectId) {
        DynamicObject[] rows;
        QFilter configFilter = new QFilter("billid", "=", (Object)projectId);
        configFilter.and("entrystatus", "!=", (Object)"A");
        for (DynamicObject row : rows = BusinessDataServiceHelper.load((String)"src_bidopenconfig", (String)"entrystatus", (QFilter[])configFilter.toArray())) {
            row.set("entrystatus", (Object)"A");
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    protected void updateTenderSupplier(IFormView view, long projectId) {
        DynamicObject[] rows;
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId);
        qFilter.and("isbidpush", "=", (Object)"1");
        for (DynamicObject row : rows = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)"isbidpush", (QFilter[])qFilter.toArray())) {
            row.set("isbidpush", (Object)"0");
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }
}

