/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.bidopencomm;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.IExtendPlugin;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcAppCache;

public class SrcBidOpenSaveSupOpenData
implements IExtendPlugin {
    private static final long serialVersionUID = 1L;

    public void saveSupOpenData(IFormView view) {
        String compPageId = SrcAppCache.get("src_supplier_open", String.class, view);
        IFormView compView = view.getView(compPageId);
        if (Objects.isNull(compView)) {
            return;
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject)compView.getModel().getDataEntity());
        DynamicObject[] rows = this.getTenderSupplierRows(view);
        if (rows.length == 0) {
            return;
        }
        Map<Long, DynamicObject> entryMap = this.getCompEntryMap(compView);
        if (CollectionUtils.isEmpty(entryMap)) {
            return;
        }
        ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>(entryMap.size());
        for (DynamicObject row : rows) {
            long billId = row.getLong("id");
            DynamicObject billObj = entryMap.get(billId);
            if (null == billObj) continue;
            row.set("rank", (Object)billObj.getBigDecimal("rank"));
            objList.add(row);
        }
        PdsCommonUtils.saveDynamicObjects(objList);
    }

    private Map<Long, DynamicObject> getCompEntryMap(IFormView compView) {
        DynamicObjectCollection rows = compView.getModel().getEntryEntity("entryentity");
        return rows.stream().collect(Collectors.groupingBy(e -> e.getLong("srcentryid"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    private DynamicObject[] getTenderSupplierRows(IFormView view) {
        QFilter qfilters = this.getProjectFilter(view);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidopensupplier", (boolean)false);
        return BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)selectFields, (QFilter[])qfilters.toArray());
    }

    private QFilter getProjectFilter(IFormView view) {
        return new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity()));
    }
}

