/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.prepare;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.ISrcBidOpenPrepare;
import kd.scm.src.common.bidopen.SrcBidOpenContext;

public class SrcBidOpenTipMessagePrepare
implements ISrcBidOpenPrepare {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext context) {
        this.getNegOpenTipMessage(context);
    }

    protected void getNegOpenTipMessage(SrcBidOpenContext context) {
        long count;
        StringBuilder message = new StringBuilder();
        QFilter qfilters = new QFilter("project", "=", context.getBillObj().getPkValue());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"tnd_tenderbill", (String)"billstatus,bizstatus,suppliertype,supplier", (QFilter[])qfilters.toArray());
        if (null != rows && rows.size() > 0) {
            List tenderList = rows.stream().filter(PdsCommonUtils.distinctByKey(row -> row.getLong("supplier"))).collect(Collectors.toList());
            count = rows.stream().filter(e -> e.getString("billstatus").equals(BillStatusEnum.AUDIT.getVal())).filter(e -> !Objects.equals(e.getString("bizstatus"), ProcessStatusEnums.TERMINATED.getValue())).filter(PdsCommonUtils.distinctByKey(row -> row.getLong("supplier"))).count();
            message.append(String.format(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5171\u53d1\u7ed9\u4f9b\u5e94\u5546(%1$s)\u5bb6\uff0c\u5df2\u6295\u6807\u4f9b\u5e94\u5546(%2$s)\u5bb6\u3002", (String)"SrcBidOpenTipMessagePrepare_0", (String)"scm-src-common", (Object[])new Object[0]), tenderList.size(), count));
        }
        qfilters.and("turns", "=", (Object)"1");
        rows = QueryServiceHelper.query((String)"tnd_quotebill", (String)"billstatus,bizstatus,suppliertype,supplier", (QFilter[])qfilters.toArray());
        if (null != rows && rows.size() > 0) {
            List quoteList = rows.stream().filter(PdsCommonUtils.distinctByKey(row -> row.getLong("supplier"))).collect(Collectors.toList());
            count = rows.stream().filter(e -> e.getString("billstatus").equals(BillStatusEnum.AUDIT.getVal())).filter(e -> !Objects.equals(e.getString("bizstatus"), ProcessStatusEnums.TERMINATED.getValue())).filter(PdsCommonUtils.distinctByKey(row -> row.getLong("supplier"))).count();
            message.append(String.format(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5171\u53d1\u7ed9\u4f9b\u5e94\u5546(%1$s)\u5bb6\uff0c\u5df2\u62a5\u4ef7\u4f9b\u5e94\u5546(%2$s)\u5bb6\u3002", (String)"SrcBidOpenTipMessagePrepare_1", (String)"scm-src-common", (Object[])new Object[0]), quoteList.size(), count));
        }
        if (message.length() > 0) {
            context.setMessage(message);
        } else {
            context.setMessage(new StringBuilder(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u6ca1\u6709\u5bf9\u5e94\u7684\u6295\u6807\u5355\u6216\u62a5\u4ef7\u5355\uff0c\u4e5f\u6ca1\u6709\u4f9b\u5e94\u5546\u6295\u6807\u6216\u62a5\u4ef7\u3002", (String)"SrcBidOpenTipMessagePrepare_2", (String)"scm-src-common", (Object[])new Object[0])));
            context.setSucced(false);
        }
    }
}

