/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bizquery;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bizquery.ISrcReferPriceHandler;

public class SrcPurOrderPriceHandler
implements ISrcReferPriceHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        DynamicObject[] rows = context.getRows();
        if (rows.length == 0) {
            return;
        }
        String materialField = this.getMaterialIdField(context);
        String unitField = this.getUnitIdField(context);
        long currencyId = PdsCommonUtils.object2Long(context.getParamMap().get("currency"));
        Set<Long> materialIds = Arrays.asList(rows).stream().map(e -> e.getLong(materialField)).collect(Collectors.toSet());
        Set<Long> unitIds = Arrays.asList(rows).stream().map(e -> e.getLong(unitField)).collect(Collectors.toSet());
        Set currencyIds = PdsCommonUtils.buildSet((Long[])new Long[]{currencyId});
        Map<String, List<DynamicObject>> purlistMap = Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getString(materialField) + '_' + e.getString(unitField) + '_' + String.valueOf(currencyId)));
        QFilter qfilters = this.getPurOrderFilter(materialIds, unitIds, currencyIds, 24);
        Map<String, DynamicObject> purOrderMap = this.getPurOrderRows(qfilters);
        if (purOrderMap.size() > 0) {
            this.setPurOrderPrice(purlistMap, purOrderMap, "price2", "price3");
        }
    }
}

