/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bizurge;

import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bizurge.ISrcBizUrgeHandler;
import kd.scm.src.common.bizurge.SrcBizUrgeUtils;

public class SrcBizUrgeSupplierEnroll
implements ISrcBizUrgeHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void queryUrgeMessage(ExtPluginContext context) {
        context.setEntityId("src_publishnotice");
        if (!BidOpenStatusEnums.NOOPEN.getValue().equals(context.getProjectObj().getString("openstatus"))) {
            context.setVerifyOk(false);
            return;
        }
        Set sourceTypeSet = PdsCommonUtils.buildSet((Long[])new Long[]{SourceTypeEnums.BID.getId(), SourceTypeEnums.BID2.getId(), SourceTypeEnums.BID3.getId(), SourceTypeEnums.BID4.getId()});
        if (!sourceTypeSet.contains(context.getProjectObj().getLong("sourcetype.id"))) {
            context.setVerifyOk(false);
            return;
        }
        if (!"2".equals(context.getProjectObj().getString("tendertype"))) {
            context.setVerifyOk(false);
            return;
        }
        DynamicObjectCollection supRows = SrcBizUrgeUtils.getNoticeSuppliers(context.getProjectId());
        if (null == supRows || supRows.size() == 0) {
            context.setVerifyOk(false);
            return;
        }
        DynamicObjectCollection supList = new ArrayList(supRows.size());
        Set<Long> supplierSet = SrcBizUrgeUtils.getEnrollSupplierIds(context.getProjectId());
        if (null == supplierSet || supplierSet.size() == 0) {
            supList = supRows;
        } else {
            for (DynamicObject supRow : supRows) {
                if (!supplierSet.add(supRow.getLong("supplier.id"))) continue;
                supList.add(supRow);
            }
        }
        if (null == supList || supList.size() == 0) {
            return;
        }
        context.setRows(supList.toArray(new DynamicObject[supList.size()]));
        SrcBizUrgeUtils.buildQueryResult(context, "supplier.id", "supplier.name");
    }

    @Override
    public void queryUrgePlanTime(ExtPluginContext context) {
    }

    @Override
    public void sendUrgeMessage(ExtPluginContext context) {
        context.setOperationKey("urgemessage");
        context.setRows(new DynamicObject[]{BusinessDataServiceHelper.loadSingle((Object)context.getProjectId(), (String)"src_publishnotice")});
        SrcBizUrgeUtils.sendUrgeMessage(context);
    }
}

