/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.src.common.calc.ISrcCalculate;
import kd.scm.src.common.calc.SrcCalcContext;

public class SrcCalcGetUnPassSupplier
implements ISrcCalculate {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        this.getNoPassSupplierMap(context);
    }

    protected void getNoPassSupplierMap(SrcCalcContext context) {
        QFilter qfilters = new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj()));
        qfilters.and("isaptitude", "=", (Object)"2");
        String selectFields = "billid,package,suppliertype,supplier";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)selectFields, (QFilter[])qfilters.toArray());
        if (null == rows || rows.size() == 0) {
            return;
        }
        switch (context.getSumType()) {
            case "2": 
            case "3": {
                Map<String, List<DynamicObject>> sumtypePackageMap = rows.stream().collect(Collectors.groupingBy(e -> e.getString("billid") + '|' + e.getString("package")));
                for (Map.Entry<String, List<DynamicObject>> sumtypePackage : sumtypePackageMap.entrySet()) {
                    String entrykey = sumtypePackage.getKey();
                    List<DynamicObject> entryValue = sumtypePackage.getValue();
                    Set supIdSet = entryValue.stream().map(e -> e.getLong("supplier")).collect(Collectors.toSet());
                    context.getNoPassSupplierMap().computeIfAbsent(entrykey, v -> new HashSet(supIdSet));
                }
                break;
            }
            default: {
                Map<String, List<DynamicObject>> sumtypeSupplierMap = rows.stream().collect(Collectors.groupingBy(e -> e.getString("billid")));
                for (Map.Entry<String, List<DynamicObject>> sumtypeSupplier : sumtypeSupplierMap.entrySet()) {
                    String entrykey = sumtypeSupplier.getKey();
                    List<DynamicObject> entryValue = sumtypeSupplier.getValue();
                    Set collect = entryValue.stream().map(e -> e.getLong("supplier")).collect(Collectors.toSet());
                    context.getNoPassSupplierMap().computeIfAbsent(entrykey, v -> new HashSet(collect));
                }
            }
        }
    }
}

