/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.enums.ResultStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.ISrcCalculate;
import kd.scm.src.common.calc.SrcCalcContext;

public class SrcCalcHandleDiscardSup
implements ISrcCalculate {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        if (context.getGlobalContext().isHandleDiscardSup()) {
            return;
        }
        QFilter supFilter = new QFilter("billid", "=", (Object)context.getBillId());
        DynamicObjectCollection supRows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"suppliertype,supplier.id,package.id,isdiscard,isaptitude", (QFilter[])supFilter.toArray());
        if (supRows == null || supRows.size() == 0) {
            return;
        }
        HashSet<Long> supSet = new HashSet<Long>(16);
        Boolean isByPackage = PdsCommonUtils.isByPackage((DynamicObject)context.getProjectObj());
        HashSet<String> discardSupSet = new HashSet<String>();
        for (DynamicObject supRow : supRows) {
            supSet.add(supRow.getLong("supplier.id"));
            if (!supRow.getBoolean("isdiscard") && !"2".equals(supRow.getString("isaptitude"))) continue;
            String supPkg = PdsCommonUtils.getSup_Pkg_Key((DynamicObject)supRow, (boolean)isByPackage);
            discardSupSet.add(supPkg);
        }
        String[] entryStatusArry = new String[]{ProjectStatusEnums.INVALID.getValue(), ProjectStatusEnums.OPENED.getValue()};
        QFilter purFilter = new QFilter("project", "=", (Object)context.getBillId());
        purFilter.and("supplier", "in", supSet);
        purFilter.and("entrystatus", "in", (Object)entryStatusArry);
        purFilter.and("entrystatus2", "!=", (Object)ProjectStatusEnums.TERMINATED.getValue());
        purFilter.and("entrystatus2", "!=", (Object)ProjectStatusEnums.INVALID.getValue());
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"suppliertype,supplier,package,entrystatus,firstrank,rank,sysresult,result,orderratio", (QFilter[])purFilter.toArray());
        if (purlistObjs == null || purlistObjs.length == 0) {
            return;
        }
        boolean haveChange = false;
        for (DynamicObject purlistObj : purlistObjs) {
            String key = PdsCommonUtils.getSup_Pkg_Key((DynamicObject)purlistObj, (boolean)isByPackage);
            if (discardSupSet.contains(key)) {
                purlistObj.set("entrystatus", (Object)ProjectStatusEnums.INVALID.getValue());
                purlistObj.set("firstrank", (Object)0);
                purlistObj.set("rank", (Object)0);
                purlistObj.set("sysresult", (Object)ResultStatusEnums.LOSE.getValue());
                purlistObj.set("result", (Object)ResultStatusEnums.LOSE.getValue());
                purlistObj.set("orderratio", (Object)BigDecimal.ZERO);
                haveChange = true;
                continue;
            }
            String entryStatus = purlistObj.getString("entrystatus");
            if (!ProjectStatusEnums.INVALID.getValue().equals(entryStatus)) continue;
            purlistObj.set("entrystatus", (Object)ProjectStatusEnums.OPENED.getValue());
            haveChange = true;
        }
        if (haveChange) {
            SaveServiceHelper.save((DynamicObject[])purlistObjs);
        }
        context.getGlobalContext().setHandleDiscardSup(Boolean.TRUE);
    }
}

