/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.enums.PdsFlowConfigEnum;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.ISrcCalculate;
import kd.scm.src.common.calc.SrcCalcContext;

public class SrcCalcHandlePurlistStatusQuickPur
implements ISrcCalculate {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        if (null != context.getGlobalContext().getCustomMap().get(SrcCalcHandlePurlistStatusQuickPur.class.getSimpleName())) {
            return;
        }
        String entityId = context.getEntityName();
        if (!"src_decision".equals(entityId) && !"src_predecision".equals(entityId)) {
            return;
        }
        DynamicObject sourceClassObj = context.getProjectObj().getDynamicObject("sourceclass");
        if (null == sourceClassObj) {
            return;
        }
        if (!Objects.equals(PdsFlowConfigEnum.QUICK_PUR.getCode(), sourceClassObj.getString("number"))) {
            return;
        }
        String tenderType = context.getProjectObj().getString("srctype.tendertype");
        if (Objects.equals(tenderType, "2")) {
            // empty if block
        }
        QFilter qFilter = new QFilter("project", "=", (Object)context.getBillId());
        qFilter.and("supplier", ">", (Object)0);
        qFilter.and("entrystatus", "in", (Object)PdsCommonUtils.buildSet((String[])new String[]{ProjectStatusEnums.TOQUOTE.getValue(), ProjectStatusEnums.QUOTED.getValue()}));
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"entrystatus", (QFilter[])new QFilter[]{qFilter});
        if (purlistObjs == null || purlistObjs.length == 0) {
            return;
        }
        for (DynamicObject purlistObj : purlistObjs) {
            purlistObj.set("entrystatus", (Object)ProjectStatusEnums.OPENED.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])purlistObjs);
        context.getGlobalContext().getCustomMap().put(SrcCalcHandlePurlistStatusQuickPur.class.getSimpleName(), true);
    }
}

