/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.ISrcCalculate;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;

public class SrcCalcInitPkgScheme
implements ISrcCalculate {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        Object schemeObj;
        context.setManageType(context.getProjectObj().getString("managetype"));
        this.resetBaseTypeRatio(context);
        this.getPackageSchemeMap(context);
        this.setPackageScheme(context);
        String ratioResults = (String)ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"orderratio");
        List<String> ratioResultSet = Arrays.stream(ratioResults.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        context.setRatioResultSet(ratioResultSet);
        if (null == context.getSchemeObj() && null != context.getCompareCfgObj() && (schemeObj = context.getCompareCfgObj().get("scheme")) instanceof DynamicObject) {
            context.setSchemeObj((DynamicObject)schemeObj);
        }
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj().getDynamicObject("srctype"));
        String presentRankType = PdsCommonUtils.object2String((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"presentRankType", (Object)"1", (long)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj())), (String)"1");
        context.setPresentRankType(presentRankType);
    }

    protected void resetBaseTypeRatio(SrcCalcContext context) {
        DynamicObject compareCfgObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillId(), (String)"src_compare_config");
        context.setCompareCfgObj(compareCfgObj);
        context.setByProject(compareCfgObj.getBoolean("isbyproject"));
        BigDecimal ratio_tec = compareCfgObj.getBigDecimal("ratio_tec");
        BigDecimal ratio_biz = compareCfgObj.getBigDecimal("ratio_biz");
        BigDecimal ratio_oth = compareCfgObj.getBigDecimal("ratio_oth");
        if (ratio_tec.add(ratio_biz).add(ratio_oth).compareTo(BigDecimal.TEN.multiply(BigDecimal.TEN)) == 0) {
            return;
        }
        DynamicObject bidOpenCfgObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillId(), (String)"src_bidopen_config");
        DynamicObjectCollection rows = bidOpenCfgObj.getDynamicObjectCollection("entryentity");
        if (rows.size() == 0) {
            return;
        }
        String scoremethod = bidOpenCfgObj.getString("scoremethod");
        HashMap<String, BigDecimal> basetypeMap = new HashMap<String, BigDecimal>(4);
        basetypeMap.put("1", BigDecimal.ZERO);
        basetypeMap.put("2", BigDecimal.ZERO);
        basetypeMap.put("3", BigDecimal.ZERO);
        HashMap<Long, DynamicObject> schemeMap = new HashMap<Long, DynamicObject>(4);
        BigDecimal sumWeight = BigDecimal.ZERO;
        for (DynamicObject row : rows) {
            BigDecimal weight = row.getBigDecimal("weight").divide(BigDecimal.TEN.multiply(BigDecimal.TEN));
            sumWeight = sumWeight.add(weight);
            long schemeId = row.getLong("scheme.id");
            DynamicObject schemeObj = (DynamicObject)schemeMap.get(schemeId);
            if (null == schemeObj) {
                schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"src_scheme");
                schemeMap.put(schemeId, schemeObj);
            }
            DynamicObjectCollection indexRows = schemeObj.getDynamicObjectCollection("entryentity");
            Map<String, List<DynamicObject>> entryMap = indexRows.stream().collect(Collectors.groupingBy(e -> e.getString("indextype.basetype")));
            for (Map.Entry<String, List<DynamicObject>> entry : entryMap.entrySet()) {
                BigDecimal sumScore = BigDecimal.ZERO;
                for (DynamicObject obj : entry.getValue()) {
                    sumScore = sumScore.add(obj.getBigDecimal("score"));
                }
                if ("3".equals(scoremethod)) {
                    basetypeMap.put(entry.getKey(), ((BigDecimal)basetypeMap.get(entry.getKey())).add(sumScore));
                    continue;
                }
                basetypeMap.put(entry.getKey(), ((BigDecimal)basetypeMap.get(entry.getKey())).add(sumScore.multiply(weight)));
            }
        }
        if (sumWeight.compareTo(BigDecimal.ZERO) == 0) {
            sumWeight = BigDecimal.ONE;
        }
        bidOpenCfgObj.set("ratio_tec", (Object)((BigDecimal)basetypeMap.get("1")).divide(sumWeight, 6, RoundingMode.HALF_DOWN));
        bidOpenCfgObj.set("ratio_biz", (Object)((BigDecimal)basetypeMap.get("2")).divide(sumWeight, 6, RoundingMode.HALF_DOWN));
        bidOpenCfgObj.set("ratio_oth", (Object)((BigDecimal)basetypeMap.get("3")).divide(sumWeight, 6, RoundingMode.HALF_DOWN));
        PdsCommonUtils.saveDynamicObjects((DynamicObject)bidOpenCfgObj);
        compareCfgObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillId(), (String)"src_compare_config");
        context.setCompareCfgObj(compareCfgObj);
    }

    protected void getPackageSchemeMap(SrcCalcContext context) {
        LinkedHashMap<String, Long> schemeMap = new LinkedHashMap<String, Long>(1);
        if (!context.getCompareCfgObj().getBoolean("ispkgscheme")) {
            long schemeId = SrmCommonUtil.getPkValue((DynamicObject)context.getCompareCfgObj().getDynamicObject("scheme"));
            if (schemeId > 0L) {
                schemeMap.put(String.valueOf(context.getBillId()), schemeId);
            } else {
                schemeMap.put(String.valueOf(context.getBillId()), 898542570521543680L);
                context.getCompareCfgObj().set("scheme", (Object)898542570521543680L);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{context.getCompareCfgObj()});
            }
        } else {
            DynamicObjectCollection rows = context.getCompareCfgObj().getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                schemeMap.put(row.getString("package.id"), row.getLong("pkgscheme.id"));
            }
        }
        context.setSchemeMap(schemeMap);
    }

    protected void setPackageScheme(SrcCalcContext context) {
        context.setPkgSchemeId(SrcCalcHelper.getFirstValue(context.getSchemeMap()));
    }
}

