/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.analy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.src.common.calc.ISrcCalcFacade;
import kd.scm.src.common.calc.SrcGlobalCalcContext;
import kd.scm.src.common.calc.analy.SrcAnalyContext;
import kd.scm.src.common.calc.rank.SrcRankFacade;
import kd.scm.src.common.util.SrcProjectMemberUtil;

public class SrcAnalyFacade
implements ISrcCalcFacade {
    private static final long serialVersionUID = 1L;
    private static final String SELECTFIELDS = "project.id project,package.id package,package.packagename packagename,category.id category,purlist.id purlist,material.id material,bidmaterial.id bidmaterial,suppliertype,supplier.id supplier,compkey.number compkey";

    @Override
    public void calculate(String entityName, long billId, SrcGlobalCalcContext globalContext, boolean isResetPurlist) {
    }

    public static void initAnalyContext(SrcAnalyContext analyContext) {
        if (analyContext == null) {
            analyContext = new SrcAnalyContext();
        }
        if (analyContext.getRows() == null) {
            if (analyContext.getBillId() > 0L || null != analyContext.getQfilter()) {
                SrcAnalyFacade.getCompareToolRowsByProjectId(analyContext);
            } else {
                SrcAnalyFacade.getCompareToolRowsByUserId(analyContext);
            }
        }
        HashSet<Long> projectSet = new HashSet<Long>(16);
        HashSet<Long> packageSet = new HashSet<Long>(16);
        HashSet<Long> categorySet = new HashSet<Long>(16);
        HashSet<Long> purlistSet = new HashSet<Long>(16);
        HashSet<Long> bidmaterialSet = new HashSet<Long>(16);
        HashSet<Long> supplierSet = new HashSet<Long>(16);
        HashSet<String> compkeySet = new HashSet<String>(16);
        if (analyContext.getRows() == null || analyContext.getRows().size() == 0) {
            projectSet.add(0L);
            packageSet.add(0L);
            categorySet.add(0L);
            bidmaterialSet.add(0L);
            purlistSet.add(0L);
            supplierSet.add(0L);
            compkeySet.add("");
        } else {
            for (DynamicObject row : analyContext.getRows()) {
                if (row.get("project") instanceof DynamicObject) {
                    projectSet.add(row.getLong("project.id"));
                    if (!"ByItem".equals(row.getString("package.name"))) {
                        packageSet.add(row.getLong("package.id"));
                    }
                    categorySet.add(row.getLong("category.id"));
                    bidmaterialSet.add(row.getLong("bidmaterial.id"));
                    purlistSet.add(row.getLong("purlist.id"));
                    supplierSet.add(row.getLong("supplier.id"));
                    compkeySet.add(row.getString("compkey.number"));
                    continue;
                }
                projectSet.add(row.getLong("project"));
                if (!"ByItem".equals(row.getString("packagename"))) {
                    packageSet.add(row.getLong("package"));
                }
                categorySet.add(row.getLong("category"));
                bidmaterialSet.add(row.getLong("bidmaterial"));
                purlistSet.add(row.getLong("purlist"));
                supplierSet.add(row.getLong("supplier"));
                compkeySet.add(row.getString("compkey"));
            }
        }
        analyContext.setProjectSet(projectSet);
        analyContext.setPackageSet(packageSet);
        analyContext.setCategorySet(categorySet);
        analyContext.setMaterialSet(bidmaterialSet);
        analyContext.setBidmaterialSet(bidmaterialSet);
        analyContext.setPurlistSet(purlistSet);
        analyContext.setSupplierSet(supplierSet);
        analyContext.setCompkeySet(compkeySet);
    }

    public static void getCompareToolRowsByProjectId(SrcAnalyContext analyContext) {
        long projectId = analyContext.getBillId();
        if (projectId > 0L) {
            QFilter qfilters = new QFilter("project", "=", (Object)projectId).and("isdiscarded", "=", (Object)"0").and("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue());
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_analysetool", (String)SELECTFIELDS, (QFilter[])qfilters.toArray());
            analyContext.setRows(rows);
        } else if (null != analyContext.getQfilter()) {
            QFilter qfilters = analyContext.getQfilter();
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_analysetool", (String)SELECTFIELDS, (QFilter[])qfilters.toArray());
            if (rows.size() > 0) {
                analyContext.setRows(rows);
            } else {
                analyContext.setRows(null);
            }
        } else {
            analyContext.setRows(null);
        }
    }

    public static Map<String, Object> getFormShowPara(long projectId) {
        SrcAnalyContext analyContext = new SrcAnalyContext();
        analyContext.setBillId(projectId);
        SrcAnalyFacade.initAnalyContext(analyContext);
        HashMap<String, Object> paraMap = new HashMap<String, Object>(16);
        paraMap.put("analyse", SerializationUtils.toJsonString((Object)analyContext));
        return paraMap;
    }

    public static QFilter getCompareToolFilterByUserId() {
        ArrayList<String> bizStatus = new ArrayList<String>(Arrays.asList("C", "D", "E", "F", "H", "I", "J"));
        QFilter qfilter = new QFilter("entrystatus", "in", bizStatus);
        Object isbidderAuth = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"isbidderauth");
        if (null == isbidderAuth || ((Boolean)isbidderAuth).booleanValue()) {
            QFilter userFilter = new QFilter("project.creator", "=", (Object)RequestContext.get().getCurrUserId());
            List<Long> projectIds = SrcProjectMemberUtil.getProjMemberIDListByBizObj("src_compare");
            projectIds.addAll(SrcProjectMemberUtil.getProjMemberIDListByBizObj("src_decision"));
            QFilter projectFilter = new QFilter("project", "in", projectIds);
            qfilter.and(userFilter.or(projectFilter));
        }
        return qfilter;
    }

    public static void getCompareToolRowsByUserId(SrcAnalyContext analyContext) {
        QFilter qfilters = SrcAnalyFacade.getCompareToolFilterByUserId();
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_analysetool", (String)SELECTFIELDS, (QFilter[])qfilters.toArray());
        analyContext.setRows(rows);
    }

    public static SrcRankFacade getInstance() {
        return (SrcRankFacade)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(SrcRankFacade.class.getName());
    }
}

