/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.rank.ISrcRankCoreCalc;
import kd.scm.src.common.calc.rank.SrcRankAutoCalcBizScore;

public class SrcRankAutoCalcBizScore_hundred
implements ISrcRankCoreCalc {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        if (ExtFilterUtils.isMatchSourceTypeAndSourceFlow((Object)SrcCalcHelper.convertContext(context), (String)this.getClass().getName(), (String)SrcRankAutoCalcBizScore.class.getSimpleName())) {
            this.calcBizScore(context);
        }
    }

    protected void calcBizScore(SrcCalcContext context) {
        BigDecimal bizScore = BigDecimal.ZERO;
        BigDecimal onehundred = new BigDecimal("100");
        BigDecimal scorePara = context.getScorePara();
        BigDecimal scorePara2 = context.getSchemeObj().getBigDecimal("scorepara2");
        if (scorePara2.compareTo(BigDecimal.ZERO) == 0) {
            scorePara2 = new BigDecimal(1);
        }
        BigDecimal bizAmount = context.getCurrBizAmount();
        BigDecimal baseAmount = context.getCurrBaseAmount();
        BigDecimal value = bizAmount.subtract(baseAmount).abs().divide(baseAmount, 6).multiply(onehundred);
        switch (context.getRankCalcType()) {
            case "1": 
            case "4": {
                if ("1".equals(context.getScoreFormula())) {
                    bizScore = bizAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : context.getBaseScore().multiply(baseAmount).divide(bizAmount, 6);
                    break;
                }
                if (!"2".equals(context.getScoreFormula())) break;
                bizScore = onehundred.subtract(value.multiply(scorePara));
                break;
            }
            case "2": {
                if ("1".equals(context.getScoreFormula())) {
                    bizScore = context.getBaseScore().multiply(bizAmount).divide(baseAmount, 6);
                    break;
                }
                if (!"2".equals(context.getScoreFormula())) break;
                bizScore = onehundred.subtract(value.multiply(scorePara));
                break;
            }
            case "3": {
                if ("1".equals(context.getScoreFormula())) {
                    bizScore = context.getBaseScore().multiply(bizAmount).divide(baseAmount, 6);
                    break;
                }
                if (!"2".equals(context.getScoreFormula())) break;
                if (bizAmount.compareTo(baseAmount) <= 0) {
                    bizScore = onehundred.subtract(value.multiply(scorePara));
                    break;
                }
                bizScore = onehundred.subtract(value.multiply(scorePara2));
                break;
            }
            case "5": 
            case "6": {
                if ("1".equals(context.getScoreFormula())) {
                    bizScore = context.getBaseScore().multiply(bizAmount).divide(baseAmount, 6);
                    break;
                }
                if (!"2".equals(context.getScoreFormula())) break;
                if (bizAmount.compareTo(baseAmount) <= 0) {
                    bizScore = context.getBizBaseScore().divide(onehundred).multiply(onehundred.add(value.multiply(scorePara)));
                    if (context.getBizMaxScore().compareTo(BigDecimal.ZERO) <= 0 || bizScore.compareTo(context.getBizMaxScore()) <= 0) break;
                    bizScore = context.getBizMaxScore();
                    break;
                }
                bizScore = context.getBizBaseScore().divide(onehundred).multiply(onehundred.subtract(value.multiply(scorePara2)));
                if (context.getBizMinScore().compareTo(BigDecimal.ZERO) <= 0 || bizScore.compareTo(context.getBizMinScore()) >= 0) break;
                bizScore = context.getBizMinScore();
                break;
            }
        }
        if (bizScore.compareTo(BigDecimal.ZERO) <= 0 && context.getSchemeObj().getBoolean("isnonnegative")) {
            bizScore = BigDecimal.ZERO;
        }
        if (bizScore.abs().compareTo(new BigDecimal(999999)) >= 0) {
            bizScore = BigDecimal.ZERO;
        }
        context.setCurrBizScore(bizScore);
    }
}

