/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankInit;
import kd.scm.src.common.util.SrcWinruleUtils;

public class SrcRankInitOrderRatioRule
implements ISrcRankInit {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        Object ratioType = context.getGlobalContext().getCustomMap().get("ratiotype");
        if (null == ratioType) {
            this.initOrderRatioRule(context);
            context.getGlobalContext().getCustomMap().put("ratiotype", context.getRatioType());
        } else {
            context.setRatioType(PdsCommonUtils.object2String((Object)ratioType, (String)"1"));
        }
    }

    private void initOrderRatioRule(SrcCalcContext context) {
        DynamicObject ratioRuleObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillId(), (String)"src_project_rule");
        context.setRatioType(PdsCommonUtils.object2String((Object)ratioRuleObj.get("ratiotype"), (String)"1"));
        if ("1".equals(context.getRatioType())) {
            return;
        }
        context.setRatioRuleObj(ratioRuleObj);
        String ratioKeyField = SrcWinruleUtils.getKeyField(ratioRuleObj);
        context.setRatioKeyField(ratioKeyField);
        Map<String, BigDecimal> orderRatioMap = SrcWinruleUtils.getOrderRatioMap(ratioRuleObj);
        context.setOrderRatioMap(orderRatioMap);
        Map<Long, String> surplusRatioMap = SrcWinruleUtils.getSurplusRatioMap(ratioRuleObj);
        context.setSurplusRatioMap(surplusRatioMap);
        Map<Long, Integer> winerQtyMap = SrcWinruleUtils.getWinerQtyMap(ratioRuleObj);
        context.setWinerQtyMap(winerQtyMap);
        Map<Long, Integer> alterQtyMap = SrcWinruleUtils.getAlterQtyMap(ratioRuleObj);
        context.setAlterQtyMap(alterQtyMap);
        Map<Long, Integer> trainQtyMap = SrcWinruleUtils.getTrainQtyMap(ratioRuleObj);
        context.setTrainQtyMap(trainQtyMap);
    }
}

