/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankProcess;

public class SrcRankLowThresholdSup
implements ISrcRankProcess {
    @Override
    public void process(SrcCalcContext context) {
        QFilter qFilter = new QFilter("project", "=", (Object)context.getBillId());
        qFilter.and("isoverthreshold", "=", (Object)Boolean.TRUE);
        qFilter.and("billid.indextype.basetype", "!=", (Object)"4");
        qFilter.and("billid.indextype.basetype", "!=", (Object)"7");
        qFilter.and("billid.bizstatus", "!=", (Object)"E");
        String selectFields = "project,package,billid.supplier,billid.suppliertype";
        DynamicObjectCollection scoreanalyseCollection = QueryServiceHelper.query((String)"src_scoreanalyse", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (context.getIsOverThresholdMap() == null) {
            context.setIsOverThresholdMap(new HashMap<String, Set<Long>>(16));
        }
        switch (context.getSumType()) {
            case "2": 
            case "3": {
                Map<String, List<DynamicObject>> sumtypePackageMap = scoreanalyseCollection.stream().collect(Collectors.groupingBy(e -> e.getString("project") + "|" + e.getString("package")));
                for (Map.Entry<String, List<DynamicObject>> sumtypePackage : sumtypePackageMap.entrySet()) {
                    String entrykey = sumtypePackage.getKey();
                    List<DynamicObject> entryValue = sumtypePackage.getValue();
                    Set supIdSet = entryValue.stream().map(e -> e.getLong("billid.supplier")).collect(Collectors.toSet());
                    context.getIsOverThresholdMap().computeIfAbsent(entrykey, v -> new HashSet(supIdSet));
                }
                break;
            }
            default: {
                Map<String, List<DynamicObject>> sumtypeSupplierMap = scoreanalyseCollection.stream().collect(Collectors.groupingBy(e -> e.getString("project")));
                for (Map.Entry<String, List<DynamicObject>> sumtypeSupplier : sumtypeSupplierMap.entrySet()) {
                    String entrykey = sumtypeSupplier.getKey();
                    List<DynamicObject> entryValue = sumtypeSupplier.getValue();
                    Set collect = entryValue.stream().map(e -> e.getLong("billid.supplier")).collect(Collectors.toSet());
                    context.getIsOverThresholdMap().computeIfAbsent(entrykey, v -> new HashSet(collect));
                }
            }
        }
    }
}

