/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankInit;

public class SrcRankResetSchemeInfo
implements ISrcRankInit {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        this.setSumTypeByAbandon(context);
        this.setSumTypeByDiscard(context);
    }

    protected void setSumTypeByAbandon(SrcCalcContext context) {
        if (StringUtils.equals((CharSequence)context.getSumType(), (CharSequence)"3")) {
            return;
        }
        QFilter qfilters = new QFilter("project.id", "=", (Object)context.getBillId()).and(new QFilter("isnew", "=", (Object)"1").or("isdiscarded", "=", (Object)"1"));
        if (context.getPkgGroupId() > 0L) {
            qfilters = qfilters.and("package.id", "=", (Object)context.getPkgGroupId());
        }
        if (QueryServiceHelper.exists((String)"src_purlistf7", (QFilter[])qfilters.toArray()) && this.isResetSumType(context)) {
            context.setSumType("3");
            String remark = ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u6709\u4f9b\u5e94\u5546\u53bb\u6807\u7684\u6216\u65b0\u589e\u6807\u7684 \uff0c\u6240\u4ee5\u6392\u540d\u6c47\u603b\u6309\u201c\u4f9b\u5e94\u5546+\u6807\u6bb5+\u6807\u7684\u201d\uff0c\u7cfb\u7edf\u81ea\u52a8\u63a8\u8350\u7ed3\u679c\u4ec5\u4f9b\u53c2\u8003\uff0c\u9700\u8981\u624b\u5de5\u786e\u8ba4\u3002", (String)"SrcRankResetSchemeInfo_0", (String)"scm-src-common", (Object[])new Object[0]);
            context.setRemark(context.getRemark() == null ? remark : context.getRemark() + "," + remark);
        }
    }

    protected void setSumTypeByDiscard(SrcCalcContext context) {
        if (!StringUtils.equals((CharSequence)context.getSumType(), (CharSequence)"1")) {
            return;
        }
        QFilter qfilters = new QFilter("billid.id", "=", (Object)context.getBillId()).and("isdiscard", "=", (Object)"1");
        if (context.getPkgGroupId() > 0L) {
            qfilters = qfilters.and("package.id", "=", (Object)context.getPkgGroupId());
        }
        if (QueryServiceHelper.exists((String)"src_bidopensupplier", (QFilter[])qfilters.toArray()) && this.isResetSumType(context)) {
            context.setSumType("2");
            String remark = ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u6709\u4f9b\u5e94\u5546\u7684\u6807\u6bb5\u88ab\u5e9f\u6807 \uff0c\u6392\u540d\u6c47\u603b\u7ef4\u5ea6\u6309\u201c\u4f9b\u5e94\u5546+\u6807\u6bb5\u201d\u3002", (String)"SrcRankResetSchemeInfo_1", (String)"scm-src-common", (Object[])new Object[0]);
            context.setRemark(context.getRemark() == null ? remark : context.getRemark() + "," + remark);
        }
    }

    protected boolean isResetSumType(SrcCalcContext context) {
        boolean isResetSumType = false;
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj().getDynamicObject("projectf7").getDynamicObject("srctype"));
        if (ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isresetsumtype", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj().getDynamicObject("projectf7"))))) {
            if (!this.isManualScore(context)) {
                isResetSumType = true;
            }
        } else if (ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isresetsumtype2", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj().getDynamicObject("projectf7"))))) {
            isResetSumType = true;
        }
        return isResetSumType;
    }

    protected boolean isManualScore(SrcCalcContext context) {
        String selectFields = "ismanualscore,isbizscore,scoretype";
        DynamicObject bidOpenCfgObj = QueryServiceHelper.queryOne((String)"src_bidopen_config", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)context.getBillId())});
        if (null == bidOpenCfgObj) {
            return false;
        }
        return bidOpenCfgObj.getBoolean("ismanualscore") || bidOpenCfgObj.getBoolean("isbizscore") || "2".equals(bidOpenCfgObj.getString("scoretype"));
    }
}

