/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.src.common.calc.ISrcCalculate;
import kd.scm.src.common.calc.SrcCalcContext;

public class SrcRankResultVerify
implements ISrcCalculate {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        if (context.isManualScore() || context.isBizScore() || context.getSourcetype().equals(SourceTypeEnums.SCHEME_AWARD.getValue()) || context.getSourcetype().equals(SourceTypeEnums.SCHEME_AWARD2.getValue())) {
            return;
        }
        this.veryfyAssessResult(context);
    }

    private void veryfyAssessResult(SrcCalcContext context) {
        List<DynamicObject> rows = context.getAllAssessList();
        if (rows.size() == 0) {
            return;
        }
        if (rows.stream().allMatch(e -> e.getBigDecimal("bizamount").compareTo(BigDecimal.ZERO) == 0)) {
            context.setAllAssessList(Collections.emptyList());
            context.getGlobalContext().setMessage(ResManager.loadKDString((String)"\u8bc4\u6807\u7ed3\u679c\u7684\u5546\u52a1\u4ef7\u683c\u5168\u90e8\u4e3a0\uff0c\u8bf7\u68c0\u67e5\uff1a1\uff09\u63a8\u8350\u65b9\u6848\u7684\u5546\u52a1\u4ef7\u683c\u7684\u53d6\u503c\u6765\u6e90\u662f\u5426\u6b63\u786e\uff1b2\uff09\u91c7\u8d2d\u6e05\u5355F7\u662f\u5426\u6709\u8be5\u5b57\u6bb5\uff1b3\uff09\u91c7\u8d2d\u6e05\u5355\u8be5\u5b57\u6bb5\u662f\u5426\u6709\u503c\uff1b4\uff09\u8fd9\u4e09\u4e2a\u5730\u65b9\u7684\u5b57\u6bb5\u540d\u548c\u6807\u8bc6\u662f\u5426\u4e00\u81f4\u3002", (String)"SrcRankResultVerify_1", (String)"scm-src-common", (Object[])new Object[0]));
            context.getGlobalContext().setSucced(false);
            return;
        }
        Map<String, List<DynamicObject>> assessMap = rows.stream().filter(e -> e.getBigDecimal("bizamount").compareTo(BigDecimal.ZERO) > 0 && e.getBigDecimal("bizscore").compareTo(BigDecimal.ZERO) > 0).collect(Collectors.groupingBy(e -> e.getString("package_id") + '_' + e.getString("purlistid0")));
        if (assessMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<DynamicObject>> entry : assessMap.entrySet()) {
            if (entry.getValue().size() < 2) continue;
            Map<String, List<DynamicObject>> valueMap = entry.getValue().stream().collect(Collectors.groupingBy(e -> e.getString("bizscore")));
            for (Map.Entry<String, List<DynamicObject>> value : valueMap.entrySet()) {
                if (value.getValue().size() < 2) continue;
                for (int i = 0; i < value.getValue().size() - 2; ++i) {
                    for (int j = i + 1; j < value.getValue().size() - 1; ++j) {
                        if (value.getValue().get(i).getBigDecimal("bizamount").compareTo(value.getValue().get(j).getBigDecimal("bizamount")) == 0) continue;
                        context.getGlobalContext().setMessage(ResManager.loadKDString((String)"\u8bc4\u6807\u7ed3\u679c\u51fa\u73b0\u5546\u52a1\u5f97\u5206\u76f8\u540c\uff0c\u4f46\u5546\u52a1\u4ef7\u683c\u4e0d\u76f8\u540c\u7684\u60c5\u51b5\uff0c\u8bf7\u786e\u8ba4\u8ba1\u7b97\u7ed3\u679c\uff0c\u6216\u91cd\u65b0\u8fdb\u884c\u7efc\u5408\u8ba1\u7b97\u3002", (String)"SrcRankResultVerify_4", (String)"scm-src-common", (Object[])new Object[0]));
                        return;
                    }
                }
            }
        }
    }
}

