/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.ratio;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.ratio.ISrcRatioProcess;

public class SrcRatioGroupPurlist
implements ISrcRatioProcess {
    @Override
    public void process(SrcCalcContext context) {
        Map<String, Map<String, BigDecimal>> ratioGValueMap;
        if (context.getPurlistObjs() == null) {
            return;
        }
        Map<String, Map<String, BigDecimal>> ratioValueMap = context.getRatioValueMap();
        if (ratioValueMap == null) {
            ratioValueMap = new HashMap<String, Map<String, BigDecimal>>(16);
        }
        if ((ratioGValueMap = context.getRatioGValueMap()) == null) {
            ratioGValueMap = new HashMap<String, Map<String, BigDecimal>>(16);
        }
        for (DynamicObject purlistObj : context.getPurlistObjs()) {
            Map<String, Object> resultMap = this.getGroupKey(context, purlistObj);
            this.setRatioValueMap(context, String.valueOf(resultMap.get("key")), (Map)resultMap.get("amount_map"), ratioValueMap);
            this.setRatioGValueMap(context, String.valueOf(resultMap.get("key_group")), (Map)resultMap.get("amount_map"), ratioGValueMap);
        }
        context.setRatioValueMap(ratioValueMap);
        context.setRatioGValueMap(ratioGValueMap);
    }

    protected Map<String, Object> getGroupKey(SrcCalcContext context, DynamicObject purlistObj) {
        DynamicObject supplierObj = purlistObj.getDynamicObject("supplier");
        DynamicObject projectObj = purlistObj.getDynamicObject("project");
        DynamicObject packageObj = purlistObj.getDynamicObject("package");
        DynamicObject categoryObj = purlistObj.getDynamicObject("category");
        String key1 = null;
        String key2 = null;
        String key3 = null;
        String key4 = null;
        key1 = supplierObj != null ? String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)supplierObj)) : "0";
        key2 = projectObj != null && context.isIsproject() ? String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)projectObj)) : "0";
        key3 = packageObj != null && context.isIspackage() ? String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)packageObj)) : "0";
        key4 = categoryObj != null && context.isIscategory() ? String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)categoryObj)) : "0";
        Map<String, BigDecimal> amountMap = SrcCalcHelper.getRatioAmount(context, purlistObj);
        String key = key1 + "|" + key2 + "|" + key3 + "|" + key4;
        String key_group = key2 + "|" + key3 + "|" + key4;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("key", key);
        resultMap.put("key_group", key_group);
        resultMap.put("amount_map", amountMap);
        return resultMap;
    }

    protected void setRatioValueMap(SrcCalcContext context, String key, Map<String, BigDecimal> amountMap, Map<String, Map<String, BigDecimal>> ratioValueMap) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        BigDecimal amount = amountMap.get("amount");
        BigDecimal taxAmount = amountMap.get("taxamount");
        BigDecimal locAmount = amountMap.get("locamount");
        BigDecimal locTaxAmount = amountMap.get("loctaxamount");
        BigDecimal locAmount2 = amountMap.get("locamount2");
        BigDecimal locTaxAmount2 = amountMap.get("loctaxamount2");
        BigDecimal result = amountMap.get("result");
        Map<String, BigDecimal> tempMap = null;
        if (ratioValueMap != null) {
            tempMap = ratioValueMap.get(key);
        }
        if (tempMap == null) {
            tempMap = new HashMap<String, BigDecimal>(16);
        } else {
            amount = amount.add(tempMap.get("amount"));
            taxAmount = taxAmount.add(tempMap.get("taxamount"));
            locAmount = locAmount.add(tempMap.get("locamount"));
            locTaxAmount = locTaxAmount.add(tempMap.get("loctaxamount"));
            locAmount2 = locAmount2.add(tempMap.get("locamount2"));
            locTaxAmount2 = locTaxAmount2.add(tempMap.get("loctaxamount2"));
            result = result.add(tempMap.get("result"));
        }
        tempMap.put("amount", amount);
        tempMap.put("taxamount", taxAmount);
        tempMap.put("locamount", locAmount);
        tempMap.put("loctaxamount", locTaxAmount);
        tempMap.put("locamount2", locAmount2);
        tempMap.put("loctaxamount2", locTaxAmount2);
        tempMap.put("result", result);
        if (ratioValueMap != null) {
            ratioValueMap.put(key, tempMap);
        }
    }

    protected void setRatioGValueMap(SrcCalcContext context, String key_group, Map<String, BigDecimal> amountMap, Map<String, Map<String, BigDecimal>> ratioGValueMap) {
        if (StringUtils.isBlank((CharSequence)key_group)) {
            return;
        }
        BigDecimal gAmount = amountMap.get("amount");
        BigDecimal gTaxAmount = amountMap.get("taxamount");
        BigDecimal glocAmount = amountMap.get("locamount");
        BigDecimal glocTaxAmount = amountMap.get("loctaxamount");
        BigDecimal glocAmount2 = amountMap.get("locamount2");
        BigDecimal glocTaxAmount2 = amountMap.get("loctaxamount2");
        Map<String, BigDecimal> gMap = null;
        if (ratioGValueMap != null) {
            gMap = ratioGValueMap.get(key_group);
        }
        if (gMap != null) {
            gAmount = gAmount.add(gMap.get("amount"));
            gTaxAmount = gTaxAmount.add(gMap.get("taxamount"));
            glocAmount = glocAmount.add(gMap.get("locamount"));
            glocTaxAmount = glocTaxAmount.add(gMap.get("loctaxamount"));
            glocAmount2 = glocAmount2.add(gMap.get("locamount2"));
            glocTaxAmount2 = glocTaxAmount2.add(gMap.get("loctaxamount2"));
        } else {
            gMap = new HashMap<String, BigDecimal>(16);
        }
        gMap.put("amount", gAmount);
        gMap.put("taxamount", gTaxAmount);
        gMap.put("locamount", glocAmount);
        gMap.put("loctaxamount", glocTaxAmount);
        gMap.put("locamount2", glocAmount2);
        gMap.put("loctaxamount2", glocTaxAmount2);
        if (ratioGValueMap != null) {
            ratioGValueMap.put(key_group, gMap);
        }
    }
}

