/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.ratio;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.ratio.ISrcRatioProcess;

public class SrcRatioTendencyAnaly
implements ISrcRatioProcess {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        QFilter qFilter = new QFilter("project", "=", (Object)context.getBillId());
        qFilter.and("isdiscarded", "=", (Object)"0");
        qFilter.and(new QFilter("entrystatus", "=", (Object)"C").or("entrystatus", "=", (Object)"D"));
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)true);
        String orderBy = "supplier,package,purlist,turns desc";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFields, (QFilter[])qFilter.toArray(), (String)orderBy);
        if (rows.size() == 0) {
            return;
        }
        DeleteServiceHelper.delete((String)"src_quotetendency", (QFilter[])new QFilter[]{new QFilter("project", "=", (Object)context.getBillId())});
        DynamicObject turnsObj = (DynamicObject)rows.stream().max((e1, e2) -> e1.getInt("turns") - e2.getInt("turns")).get();
        int maxTurns = turnsObj.getInt("turns");
        Map<String, List<DynamicObject>> lastTurnsMap = rows.stream().collect(Collectors.groupingBy(e -> String.valueOf(e.getLong("supplier")) + '_' + String.valueOf(e.getLong("package")) + '_' + String.valueOf(e.getLong("purlist"))));
        Map<String, DynamicObject> everyTurnsMap = rows.stream().collect(Collectors.groupingBy(e -> String.valueOf(e.getLong("supplier")) + '_' + String.valueOf(e.getLong("package")) + '_' + String.valueOf(e.getLong("purlist")) + '_' + e.getString("turns"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        List properties = null;
        HashSet<String> excludedFields = new HashSet<String>();
        excludedFields.add("seq");
        ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>();
        for (int turns = 1; turns <= maxTurns && turns <= 30; ++turns) {
            for (Map.Entry<String, List<DynamicObject>> entry : lastTurnsMap.entrySet()) {
                String key = entry.getKey() + '_' + String.valueOf(turns);
                DynamicObject purlistObj = everyTurnsMap.get(key);
                if (null == purlistObj) {
                    for (DynamicObject preTurnsObj : entry.getValue()) {
                        if (preTurnsObj.getInt("turns") > turns) continue;
                        purlistObj = preTurnsObj;
                        break;
                    }
                }
                if (null == purlistObj) continue;
                DynamicObject tendencyObj = BusinessDataServiceHelper.newDynamicObject((String)"src_quotetendency");
                if (null == properties) {
                    properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)tendencyObj);
                }
                PdsCommonUtils.copyDynamicObjectValue((DynamicObject)purlistObj, (DynamicObject)tendencyObj, (List)properties, excludedFields, (int)1);
                tendencyObj.set("turns", (Object)turns);
                objList.add(tendencyObj);
            }
        }
        PdsCommonUtils.saveDynamicObjects(objList);
    }
}

