/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.total;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.SrcRankFacade;
import kd.scm.src.common.calc.total.ISrcTotalResult;

public class SrcTotalHandleSumAmount
implements ISrcTotalResult {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        DynamicObject[] resultRows = this.getUpdateRows(context);
        Map<Long, DynamicObject> supplierIpMap = this.getSupplierIpMap(context);
        DynamicObjectCollection purlistRows = this.getPurlistRows(context);
        if (resultRows.length == 0 || purlistRows.size() == 0) {
            return;
        }
        List<DynamicObject> rows = null;
        SrcRankFacade.getPkgSchemeInfo(context);
        SrcRankFacade.resetPkgSchemeInfo(context);
        for (DynamicObject resultRow : resultRows) {
            switch (context.getSumType()) {
                case "1": {
                    rows = purlistRows.stream().filter(e -> e.getLong("supplier.id") == resultRow.getLong("supplier.id")).collect(Collectors.toList());
                    break;
                }
                case "2": {
                    rows = purlistRows.stream().filter(e -> e.getLong("supplier.id") == resultRow.getLong("supplier.id") && e.getLong("package.id") == resultRow.getLong("package.id")).collect(Collectors.toList());
                    break;
                }
                case "3": {
                    rows = purlistRows.stream().filter(e -> e.getLong("supplier.id") == resultRow.getLong("supplier.id") && e.getLong("id") == resultRow.getLong("purlist.id")).collect(Collectors.toList());
                    break;
                }
            }
            if (null != rows && rows.size() > 0) {
                this.sumAmountAndSetValue(resultRow, rows);
            }
            this.updateSupplierIP(resultRow, supplierIpMap);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])resultRows);
    }

    private void updateSupplierIP(DynamicObject resultRow, Map<Long, DynamicObject> supplierIpMap) {
        long supplierId = resultRow.getLong("supplier.id");
        DynamicObject obj = supplierIpMap.get(supplierId);
        if (null != obj) {
            resultRow.set("supplierip", (Object)obj.getString("supplierip"));
            resultRow.set("suppliercode", (Object)obj.getString("suppliercode"));
        }
    }

    private void sumAmountAndSetValue(DynamicObject resultRow, List<DynamicObject> rows) {
        BigDecimal locAmount = rows.stream().map(e -> e.getBigDecimal("locamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal locTaxAmount = rows.stream().map(e -> e.getBigDecimal("loctaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        resultRow.set("locamount", (Object)locAmount);
        resultRow.set("loctaxamount", (Object)locTaxAmount);
    }

    private DynamicObject[] getUpdateRows(SrcCalcContext context) {
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidassess_biz", (boolean)false);
        QFilter qfilters = new QFilter("billid", "=", context.getProjectObj().getPkValue());
        return BusinessDataServiceHelper.load((String)"src_bidassess_biz", (String)selectFields, (QFilter[])qfilters.toArray());
    }

    private DynamicObjectCollection getPurlistRows(SrcCalcContext context) {
        String selectFields = "id,suppliertype,supplier.id,package.id,purlist.id,locamount,loctaxamount";
        QFilter purlistFilter = new QFilter("project.id", "in", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj())).and("isdiscarded", "=", (Object)"0").and("entrystatus", "in", Arrays.asList(ProjectStatusEnums.OPENED.getValue(), ProjectStatusEnums.DECIDED.getValue(), ProjectStatusEnums.SIGNED.getValue()));
        return QueryServiceHelper.query((String)"src_purlistf7", (String)selectFields, (QFilter[])purlistFilter.toArray());
    }

    private Map<Long, DynamicObject> getSupplierIpMap(SrcCalcContext context) {
        String selectFields = "suppliertype,supplier.id,supplierip,suppliercode";
        QFilter qfilters = new QFilter("billid", "=", context.getProjectObj().getPkValue());
        qfilters.and("supplierip", "!=", (Object)Character.valueOf(' '));
        qfilters.and("supplierip", "is not null", (Object)"");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)selectFields, (QFilter[])qfilters.toArray());
        if (rows.size() == 0) {
            return Collections.emptyMap();
        }
        return rows.stream().collect(Collectors.groupingBy(e -> e.getLong("supplier.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }
}

