/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcBidCategoryHandleService
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        DynamicObject purlistObjects = TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)"src_categorychg");
        this.updatePurListByEntity(bidChangeObj, purlistObjects, "src_purlistf7");
        this.updatePurListByEntity(bidChangeObj, purlistObjects, "src_contractentry");
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcBidCategoryHandleService_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    private boolean updatePurListByEntity(DynamicObject bidChangeObj, DynamicObject purlistObjects, String entityKey) {
        DynamicObjectCollection purCollections = purlistObjects.getDynamicObjectCollection("entryentity");
        Long projectId = (Long)bidChangeObj.getDynamicObject("project").getPkValue();
        HashMap<Long, DynamicObject> purlistIdMap = new HashMap<Long, DynamicObject>(purCollections.size());
        HashSet<Long> purListIdSet = new HashSet<Long>(purCollections.size());
        for (DynamicObject purlistCol : purCollections) {
            Long newCategoryId = purlistCol.getLong("category1.id");
            if (newCategoryId == 0L) continue;
            Long purlistID = purlistCol.getLong("purlist.id");
            purListIdSet.add(purlistID);
            purlistIdMap.put(purlistID, purlistCol);
        }
        QFilter colFilter = new QFilter("purlist", "in", purListIdSet).and("project", "=", (Object)projectId);
        DynamicObject[] purListF7Cols = BusinessDataServiceHelper.load((String)entityKey, (String)"id,purlist,billtype,entrystatus,packagename,material,materialnane,category", (QFilter[])colFilter.toArray());
        if (purListF7Cols.length > 0) {
            for (DynamicObject purlistCol : purListF7Cols) {
                Long newCategoryId;
                Long purlistId = purlistCol.getLong("purlist.id");
                DynamicObject purListEntryobj = (DynamicObject)purlistIdMap.get(purlistId);
                if (Objects.isNull(purListEntryobj) || (newCategoryId = Long.valueOf(purListEntryobj.getLong("category1.id"))) == 0L) continue;
                purlistCol.set("category", (Object)newCategoryId);
            }
        } else {
            return false;
        }
        SaveServiceHelper.save((DynamicObject[])purListF7Cols);
        return true;
    }

    public void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

