/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcBidNumResultChgTndSumAmount
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        String message = ResManager.loadKDString((String)"\u5b9a\u6807\u7ed3\u679c\u3001\u4efd\u989d\u548c\u4ef7\u683c\u53d8\u66f4--\u53d8\u66f4\u540e\u5904\u7406--\u66f4\u65b0\u6295\u6807\u5355\u548c\u62a5\u4ef7\u5355\u7684\u6c47\u603b\u91d1\u989d\u5931\u8d25\u3002", (String)"SrcBidNumResultChgTndSumAmount_0", (String)"scm-src-common", (Object[])new Object[0]);
        HandleResult result = new HandleResult();
        result.setSuccess(false);
        DynamicObject bidChangeObj = handleEvent.getObj();
        long projectId = bidChangeObj.getLong("project.id");
        Set<Long> purlistIdSet = this.getChgPurlistIdSet(bidChangeObj);
        DynamicObjectCollection purlistObjs = this.getPurlistObjs(projectId, purlistIdSet);
        this.updateTndSumAmount(projectId, purlistObjs, "tnd_tenderbill");
        this.updateTndSumAmount(projectId, purlistObjs, "tnd_quotebill");
        result.setSuccess(true);
        message = ResManager.loadKDString((String)"\u5b9a\u6807\u7ed3\u679c\u3001\u4efd\u989d\u548c\u4ef7\u683c\u53d8\u66f4--\u53d8\u66f4\u540e\u5904\u7406--\u66f4\u65b0\u6295\u6807\u5355\u548c\u62a5\u4ef7\u5355\u7684\u6c47\u603b\u91d1\u989d\u6210\u529f\u3002", (String)"SrcBidNumResultChgTndSumAmount_1", (String)"scm-src-common", (Object[])new Object[0]);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    protected void updateTndSumAmount(long projectId, DynamicObjectCollection purlistObjs, String entityName) {
        HashSet<Long> supplierSet = new HashSet<Long>();
        HashSet<String> turnsSet = new HashSet<String>();
        for (DynamicObject purlistObj : purlistObjs) {
            supplierSet.add(purlistObj.getLong("supplier"));
            turnsSet.add(purlistObj.getString("turns"));
        }
        Map<String, List<DynamicObject>> keyMap = purlistObjs.stream().collect(Collectors.groupingBy(e -> e.getString("turns") + '|' + e.getString("supplier")));
        String selectFields = null;
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("supplier", "in", supplierSet);
        qfilters.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        if (entityName.equals("tnd_quotebill")) {
            qfilters.and("turns", "in", turnsSet);
            selectFields = "turns,supplier,project,sumamount,sumtaxamount";
        } else {
            selectFields = "supplier,project,sumamount,sumtaxamount";
        }
        DynamicObject[] billObjs = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilters.toArray());
        if (null != billObjs && billObjs.length > 0) {
            this.updateTndSumAmount(billObjs, keyMap.keySet(), entityName);
        }
    }

    protected void updateTndSumAmount(DynamicObject[] billObjs, Set<String> keySet, String entityName) {
        ArrayList<DynamicObject> billObjList = new ArrayList<DynamicObject>(billObjs.length);
        for (DynamicObject billObj : billObjs) {
            String myKey;
            if (entityName.equals("tnd_quotebill") && !keySet.contains(myKey = billObj.getString("turns") + '|' + billObj.getString("supplier.id"))) continue;
            QFilter purlistFilter = new QFilter("parentid", "=", (Object)String.valueOf(billObj.getPkValue())).and("isdiscarded", "=", (Object)"0");
            DynamicObjectCollection purlistObjs = QueryServiceHelper.query((String)"src_purlistf7", (String)"amount,taxamount", (QFilter[])new QFilter[]{purlistFilter});
            if (purlistObjs == null || purlistObjs.size() == 0) continue;
            BigDecimal sumAmount = BigDecimal.ZERO;
            BigDecimal sumTaxAmount = BigDecimal.ZERO;
            for (DynamicObject purlistObj : purlistObjs) {
                sumAmount = sumAmount.add(purlistObj.getBigDecimal("amount"));
                sumTaxAmount = sumTaxAmount.add(purlistObj.getBigDecimal("taxamount"));
            }
            billObj.set("sumamount", (Object)sumAmount);
            billObj.set("sumtaxamount", (Object)sumTaxAmount);
            billObjList.add(billObj);
        }
        PdsCommonUtils.saveDynamicObjects(billObjList);
    }

    public void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }

    protected Set<Long> getChgPurlistIdSet(DynamicObject bidChangeObj) {
        DynamicObject chgCompObj = TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)"src_decisionchg");
        DynamicObjectCollection rows = chgCompObj.getDynamicObjectCollection("entryentity");
        return rows.stream().filter(e -> e.getBoolean("isnew")).map(e -> e.getLong("srcentryid")).collect(Collectors.toSet());
    }

    protected DynamicObjectCollection getPurlistObjs(long projectId, Set<Long> purlistIdSet) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("id", "in", purlistIdSet);
        String seelctFields = "turns,supplier.id supplier";
        return QueryServiceHelper.query((String)"src_purlistf7", (String)seelctFields, (QFilter[])qfilter.toArray());
    }
}

