/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.calc.SrcGlobalCalcContext;
import kd.scm.src.common.calc.ratio.SrcRatioFacade;
import kd.scm.src.common.calc.total.SrcTotalFacade;
import kd.scm.src.common.contract.SrcContractUtils;

public class SrcBidNumberHandleService
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        DynamicObject[] purlistF7Cols;
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        DynamicObject purlistObjects = TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)"src_ratiochg");
        DynamicObjectCollection purCollections = purlistObjects.getDynamicObjectCollection("entryentity");
        Map<Long, String> purMap = purCollections.stream().collect(Collectors.toMap(obj -> Optional.ofNullable(obj.getString("srcentryid")).map(Long::parseLong).orElse(0L), obj -> obj.getString("orderrationew")));
        String billno = bidChangeObj.getDynamicObject("project").getString("billno");
        long id = bidChangeObj.getDynamicObject("project").getLong("id");
        for (DynamicObject purlistF7Col : purlistF7Cols = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"id,entryid,orderratio", (QFilter[])new QFilter[]{new QFilter("project.id", "=", (Object)id).and("entryid", "in", purMap.keySet())})) {
            purlistF7Col.set("orderratio", (Object)purMap.get(purlistF7Col.getLong("entryid")));
        }
        SaveServiceHelper.save((DynamicObject[])purlistF7Cols);
        DynamicObject decProject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"src_decision");
        DynamicObject supplierCols = TemplateUtil.getComponentData((String)decProject.getString("id"), (String)"src_decisionsum_sup");
        if (supplierCols == null) {
            supplierCols = TemplateUtil.getComponentData((String)decProject.getString("id"), (String)"src_decisionsup_quick");
        }
        String sumtype = supplierCols.getString("sumtype");
        SrcGlobalCalcContext globalContext = new SrcGlobalCalcContext();
        globalContext.setIsAllowSynthCalc(1);
        if ("1".equals(sumtype)) {
            SrcRatioFacade.getInstance().calculate("src_decision", decProject.getLong("id"), globalContext, Boolean.FALSE);
        }
        SrcTotalFacade.getInstance().calculate("src_decision", decProject.getLong("id"), globalContext, Boolean.FALSE);
        ExtPluginContext context = new ExtPluginContext();
        context.setBillObj(decProject);
        SrcContractUtils.deleteContractEntry(context);
        SrcContractUtils.createContractEntry(context);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcBidNumberHandleService_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        return result;
    }
}

