/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcBidProjectEndHandleInviteLetter
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        long projectId = bidChangeObj.getDynamicObject("project").getLong("id");
        this.updateInviteLetter("tnd_inviteletter", projectId);
        this.updateInviteLetter("tnd_winnotice", projectId);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcBidProjectEndHandleInviteLetter_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    public void updateInviteLetter(String entityName, long projectId) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("cfmstatus", "=", (Object)"A");
        DynamicObject[] inviteObjs = BusinessDataServiceHelper.load((String)entityName, (String)"cfmstatus,cfmdate", (QFilter[])qfilter.toArray());
        if (inviteObjs.length == 0) {
            return;
        }
        for (DynamicObject inviteObj : inviteObjs) {
            inviteObj.set("cfmstatus", (Object)ProjectStatusEnums.CLOSED.getValue());
            inviteObj.set("cfmdate", (Object)TimeServiceHelper.now());
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])inviteObjs);
    }

    private void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

