/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.feemanage.FeeManageUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcBidReplenishSupplierService
implements IDataHandleService {
    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        String manageType = bidChangeObj.getDynamicObject("project").getString("managetype");
        if ("3".equals(manageType)) {
            this.createInviteSupplierByItemSupplier(bidChangeObj);
            this.updateProjectItemSupplier(bidChangeObj);
        }
        this.updateProjectInviteSupplier(bidChangeObj);
        this.updateProjectTenderSupplier(bidChangeObj);
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj.getDynamicObject("project"));
        FeeManageUtils.createPaymentEntry((long)projectId);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcBidReplenishSupplierService_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    private void createInviteSupplierByItemSupplier(DynamicObject bidChangeObj) {
        DynamicObject chgItemSupObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_itemsupplier_chg");
        if (null == chgItemSupObj) {
            return;
        }
        DynamicObjectCollection chgItemSupRows = chgItemSupObj.getDynamicObjectCollection("entryentity");
        if (chgItemSupRows == null || chgItemSupRows.size() == 0) {
            return;
        }
        DynamicObject chgInviteSupObj = this.getInviteSupplierObj(bidChangeObj);
        if (null == chgInviteSupObj) {
            return;
        }
        DynamicObjectCollection chgInviteSupRows = chgInviteSupObj.getDynamicObjectCollection("entrysupplier");
        if (chgInviteSupRows != null && chgInviteSupRows.size() > 0) {
            chgInviteSupRows.removeAll((Collection)chgInviteSupRows);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chgInviteSupObj});
        }
        DynamicObject supplierObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_supplier");
        ArrayList<DynamicObject> chgInviteSupObjs = new ArrayList<DynamicObject>(8);
        for (DynamicObject chgItemSupRow : chgItemSupRows) {
            DynamicObject[] supplierObjs;
            long packageId = chgItemSupRow.getLong("purlist.package.id");
            Set supplierIdSet = MultiBasedataUtils.getBasedataIdSet((DynamicObject)chgItemSupRow, (String)"supplier");
            for (DynamicObject supplier : supplierObjs = (DynamicObject[])BusinessDataServiceHelper.load((Object[])supplierIdSet.toArray(new Object[0]), (IDataEntityType)supplierObj.getDataEntityType())) {
                DynamicObject chgInviteSupRow = BusinessDataServiceHelper.newDynamicObject((String)"src_supplierinvite");
                SupplierUtil.setInviteSupplierEntry((DynamicObject)chgInviteSupRow, (DynamicObject)supplier, (long)SrmCommonUtil.getPkValue((DynamicObject)chgInviteSupObj), (long)packageId);
                chgInviteSupObjs.add(chgInviteSupRow);
            }
        }
        if (chgInviteSupObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])chgInviteSupObjs.toArray(new DynamicObject[chgInviteSupObjs.size()]));
        }
    }

    private void updateProjectItemSupplier(DynamicObject bidChangeObj) {
        DynamicObject chgItemSupObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_itemsupplier_chg");
        if (null == chgItemSupObj) {
            return;
        }
        DynamicObjectCollection chgItemSupRows = chgItemSupObj.getDynamicObjectCollection("entryentity");
        if (chgItemSupRows == null || chgItemSupRows.size() == 0) {
            return;
        }
        DynamicObject projectObj = bidChangeObj.getDynamicObject("project");
        DynamicObject proItemSupObj = TemplateUtil.getComponentData((String)projectObj.getString("id"), (String)"src_itemsupplier");
        if (null == proItemSupObj) {
            return;
        }
        DynamicObjectCollection proItemSupRows = proItemSupObj.getDynamicObjectCollection("entryentity");
        if (proItemSupRows == null || proItemSupRows.size() == 0) {
            return;
        }
        block0: for (DynamicObject chgItemSupRow : chgItemSupRows) {
            long chgPurlistId = chgItemSupRow.getLong("purlist.id");
            for (DynamicObject proItemSupRow : proItemSupRows) {
                if (chgPurlistId != proItemSupRow.getLong("purlist.id")) continue;
                Set supplierIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)chgItemSupRow, (String)"supplier");
                MultiBasedataUtils.setMultiBasedataForEntryRow((DynamicObject)proItemSupRow, (Set)supplierIds, (String)"supplier");
                continue block0;
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{proItemSupObj});
    }

    private void updateProjectInviteSupplier(DynamicObject bidChangeObj) {
        DynamicObject chgInviteSupObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_invitesupplier_chg");
        if (null == chgInviteSupObj) {
            return;
        }
        DynamicObjectCollection chgInviteSupRows = chgInviteSupObj.getDynamicObjectCollection("entrysupplier");
        if (chgInviteSupRows == null || chgInviteSupRows.size() == 0) {
            return;
        }
        DynamicObject projectObj = bidChangeObj.getDynamicObject("project");
        DynamicObject proInviteSupObj = TemplateUtil.getComponentData((String)projectObj.getString("id"), (String)"src_supplier_invite");
        if (null == proInviteSupObj) {
            return;
        }
        DynamicObjectCollection proInviteSupRows = proInviteSupObj.getDynamicObjectCollection("entrysupplier");
        Map<Object, Object> proInviteSupMap = new HashMap(16);
        Set<Object> proInviteSupSet = new HashSet(16);
        if (proInviteSupRows != null && proInviteSupRows.size() > 0) {
            proInviteSupMap = proInviteSupRows.stream().collect(Collectors.groupingBy(e -> e.getString("package.id") + '|' + e.getString("supplier.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
            proInviteSupSet = proInviteSupRows.stream().map(e -> e.getString("package.id") + '|' + e.getString("supplier.id")).collect(Collectors.toSet());
        }
        QFilter pkgfilter = new QFilter("project.id", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        DynamicObjectCollection pkgRows = QueryServiceHelper.query((String)"src_packagef7", (String)"id", (QFilter[])new QFilter[]{pkgfilter});
        ArrayList<DynamicObject> proInviteSupObjs = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> proEnrollSupObjs = new ArrayList<DynamicObject>(8);
        List rowProperties = null;
        Set excludedFields = Collections.emptySet();
        boolean isChanged = false;
        for (DynamicObject chgInviteSupRow : chgInviteSupRows) {
            String key;
            DynamicObject supplierObj = chgInviteSupRow.getDynamicObject("supplier");
            long packageId = SrmCommonUtil.getPkValue((DynamicObject)chgInviteSupRow.getDynamicObject("package"));
            if (packageId == 0L && pkgRows != null && pkgRows.size() > 0) {
                packageId = ((DynamicObject)pkgRows.get(0)).getLong("id");
            }
            if (!proInviteSupSet.add(key = String.valueOf(packageId) + '|' + supplierObj.getString("id"))) {
                DynamicObject proSupObj = (DynamicObject)proInviteSupMap.get(key);
                if (null == proSupObj || !this.isChanged(proSupObj, chgInviteSupRow)) continue;
                isChanged = true;
                proSupObj.set("isinvite", chgInviteSupRow.get("isinvite"));
                proSupObj.set("ispuragent", chgInviteSupRow.get("ispuragent"));
                proSupObj.set("isfeeagent", chgInviteSupRow.get("isfeeagent"));
                proSupObj.set("ispuraptitude", chgInviteSupRow.get("ispuraptitude"));
                proSupObj.set("isexemptapt", chgInviteSupRow.get("isexemptapt"));
                continue;
            }
            DynamicObject proInviteSupRow = BusinessDataServiceHelper.newDynamicObject((String)"src_supplierinvite");
            SupplierUtil.setInviteSupplierEntry((DynamicObject)proInviteSupRow, (DynamicObject)supplierObj, (long)SrmCommonUtil.getPkValue((DynamicObject)proInviteSupObj), (long)packageId);
            proInviteSupRow.set("isinvite", chgInviteSupRow.get("isinvite"));
            proInviteSupRow.set("ispuragent", chgInviteSupRow.get("ispuragent"));
            proInviteSupRow.set("isfeeagent", chgInviteSupRow.get("isfeeagent"));
            proInviteSupRow.set("ispuraptitude", chgInviteSupRow.get("ispuraptitude"));
            proInviteSupRow.set("isexemptapt", chgInviteSupRow.get("isexemptapt"));
            DynamicObjectCollection rows = chgInviteSupRow.getDynamicObjectCollection("supplieruser");
            if (null != rows && rows.size() > 0) {
                MultiBasedataUtils.setMultiBasedataForObject((DynamicObject)proInviteSupRow, (DynamicObjectCollection)rows, (String)"supplieruser");
            }
            DynamicObject proEnrollSupRow = BusinessDataServiceHelper.newDynamicObject((String)"src_enrollsupplier");
            if (null == rowProperties) {
                rowProperties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)proEnrollSupRow);
            }
            PdsCommonUtils.copyDynamicObjectValue((DynamicObject)proInviteSupRow, (DynamicObject)proEnrollSupRow, (List)rowProperties, excludedFields, (int)-1);
            proInviteSupObjs.add(proInviteSupRow);
            proEnrollSupObjs.add(proEnrollSupRow);
        }
        if (isChanged) {
            PdsCommonUtils.saveDynamicObjects((DynamicObject)proInviteSupObj);
        }
        if (proInviteSupObjs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])proInviteSupObjs.toArray(new DynamicObject[proInviteSupObjs.size()]));
            SaveServiceHelper.save((DynamicObject[])proEnrollSupObjs.toArray(new DynamicObject[proEnrollSupObjs.size()]));
        }
    }

    private void updateProjectTenderSupplier(DynamicObject bidChangeObj) {
        DynamicObject inviteSupplierObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_invitesupplier_chg");
        if (null == inviteSupplierObj) {
            return;
        }
        DynamicObjectCollection supplierRows = inviteSupplierObj.getDynamicObjectCollection("entrysupplier");
        if (supplierRows == null || supplierRows.size() == 0) {
            return;
        }
        DynamicObject projectObj = bidChangeObj.getDynamicObject("project");
        QFilter tenderQFilter = new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        DynamicObjectCollection tenderSupRows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"package.id,supplier.id", (QFilter[])tenderQFilter.toArray());
        Set proTenderSupSet = tenderSupRows.stream().map(e -> e.getString("package.id") + '|' + e.getString("supplier.id")).collect(Collectors.toSet());
        DynamicObjectCollection newSupplierRows = new DynamicObjectCollection();
        for (DynamicObject supplierRow : supplierRows) {
            String key = supplierRow.getString("package.id") + '|' + supplierRow.getString("supplier.id");
            if (!proTenderSupSet.add(key)) continue;
            newSupplierRows.add((Object)supplierRow);
        }
        if (newSupplierRows.size() > 0) {
            ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>(8);
            projectObj = BusinessDataServiceHelper.loadSingle((Object)bidChangeObj.getDynamicObject("project").getPkValue(), (String)"src_project");
            DynamicObject srcType = projectObj.getDynamicObject("srctype");
            if (Objects.nonNull(srcType)) {
                srcType.set("isneedinvite", (Object)false);
            }
            SrcPurListUtil.createTenderSupEntry(projectObj, newSupplierRows, objList);
            if (objList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])objList.toArray(new DynamicObject[0]));
            }
        }
    }

    private DynamicObject getInviteSupplierObj(DynamicObject bidChangeObj) {
        DynamicObject chgInviteSupObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_invitesupplier_chg");
        if (null == chgInviteSupObj) {
            chgInviteSupObj = TemplateUtil.createCompData((String)"src_bidchange", (long)SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj), (String)"src_invitesupplier_chg");
        }
        return chgInviteSupObj;
    }

    public void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }

    public boolean isChanged(DynamicObject proSupObj, DynamicObject chgInviteSupRow) {
        return proSupObj.getBoolean("isinvite") != chgInviteSupRow.getBoolean("isinvite") || proSupObj.getBoolean("ispuragent") != chgInviteSupRow.getBoolean("ispuragent") || proSupObj.getBoolean("isfeeagent") != chgInviteSupRow.getBoolean("isfeeagent") || proSupObj.getBoolean("ispuraptitude") != chgInviteSupRow.getBoolean("ispuraptitude");
    }
}

