/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;
import kd.scm.src.common.util.SrcSchemeChgUtils;

public class SrcBidSchemeChgDeleteOldData
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        String message = ResManager.loadKDString((String)"\u5220\u9664\u65e7\u65b9\u6848\u6216\u8bc4\u59d4\u5931\u8d25\u3002", (String)"SrcBidSchemeChgDeleteOldData_0", (String)"scm-src-common", (Object[])new Object[0]);
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj.getDynamicObject("project"));
        DynamicObject newBidSchemeObj = TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)"src_bidschemechg");
        if (null == newBidSchemeObj) {
            result.setSuccess(false);
            this.handleLog(handleEvent, message);
            return result;
        }
        DynamicObjectCollection newBidSchemeRows = newBidSchemeObj.getDynamicObjectCollection("entryentity");
        Boolean ismultipackage = bidChangeObj.getDynamicObject("project").getBoolean("ismultipackage");
        HashSet<Long> packageIds = new HashSet<Long>(1);
        HashSet<Long> oldSchemeIds = new HashSet<Long>(1);
        for (DynamicObject newBidSchemeRow : newBidSchemeRows) {
            long schemeId = newBidSchemeRow.getLong("scheme.id");
            long newSchemeId = newBidSchemeRow.getLong("newscheme.id");
            DynamicObjectCollection newscorer = (DynamicObjectCollection)newBidSchemeRow.get("newscorer");
            if (newSchemeId == 0L && newscorer.size() == 0) continue;
            oldSchemeIds.add(schemeId);
            if (!ismultipackage.booleanValue()) {
                packageIds.add(0L);
            }
            packageIds.add(newBidSchemeRow.getLong("package.id"));
        }
        Object templateObj = bidChangeObj.get("template");
        String templateNumber = SrcSchemeChgUtils.getTemplateNumber(templateObj);
        String resultF7 = null;
        String fieldName = null;
        if ("SYS099".equals(templateNumber)) {
            resultF7 = "src_aptituderesultf7";
            fieldName = "isaptpush";
        }
        if ("SYS100".equals(templateNumber)) {
            resultF7 = "src_aptituderesult2f7";
            fieldName = "isaptpush2";
        }
        if ("SYS101".equals(templateNumber)) {
            resultF7 = "src_bidassess_tec";
            fieldName = "isbidpush";
        }
        SrcSchemeChgUtils.deleteConfigSchemeData(resultF7, projectId, packageIds, oldSchemeIds);
        SrcSchemeChgUtils.updateTenderSupplier(fieldName, projectId, packageIds);
        SrcSchemeChgUtils.updateEnrollSupplier(fieldName, projectId, packageIds);
        result.setSuccess(true);
        message = ResManager.loadKDString((String)"\u5220\u9664\u65e7\u65b9\u6848\u6216\u8bc4\u59d4\u6210\u529f\u3002", (String)"SrcBidSchemeChgDeleteOldData_1", (String)"scm-src-common", (Object[])new Object[0]);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    public void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

