/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcDemandQtyChgHandleService
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        Map<Long, DynamicObject> chgEntryMap;
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        long demandId = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj.getDynamicObject("demand"));
        DynamicObject demandObj = BusinessDataServiceHelper.loadSingle((Object)demandId, (String)"src_demand");
        DynamicObject currencyObj = demandObj.getDynamicObject("curr");
        int amtprecision = 6;
        if (null != currencyObj) {
            amtprecision = currencyObj.getInt("amtprecision");
        }
        if (null == (chgEntryMap = this.getChgEntryMap(bidChangeObj)) || chgEntryMap.size() == 0) {
            return result;
        }
        DynamicObject[] materialRows = BusinessDataServiceHelper.load((String)"src_demandf7two", (String)"qty,tax,amount,taxamount,material1,unit2,baseqty,baseunit", (QFilter[])new QFilter[]{new QFilter("source", "=", (Object)demandId)});
        ArrayList<DynamicObject> materialList = new ArrayList<DynamicObject>(8);
        this.updateDemandEntry(demandObj, materialRows, chgEntryMap, amtprecision, materialList);
        PdsCommonUtils.saveDynamicObjects(materialList);
        this.updateDemandSumAmount(demandObj, materialRows);
        this.updateDemandSceneEntry(demandObj, materialRows);
        PdsCommonUtils.saveDynamicObjects((DynamicObject)demandObj);
        this.updatePurlistEntry(chgEntryMap, amtprecision);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcDemandQtyChgHandleService_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    protected void updateDemandEntry(DynamicObject demandObj, DynamicObject[] materialRows, Map<Long, DynamicObject> chgEntryMap, int amtprecision, List<DynamicObject> materialList) {
        for (DynamicObject mRow : materialRows) {
            DynamicObject chgObj = chgEntryMap.get(mRow.getLong("id"));
            if (null == chgObj) continue;
            this.setEntryValue(mRow, chgObj, amtprecision);
            materialList.add(mRow);
        }
    }

    protected void updateDemandSumAmount(DynamicObject demandObj, DynamicObject[] materialRows) {
        BigDecimal sumtax = BigDecimal.ZERO;
        BigDecimal sumamount = BigDecimal.ZERO;
        BigDecimal sumtaxamount = BigDecimal.ZERO;
        for (DynamicObject row : materialRows) {
            sumtax = sumtax.add(row.getBigDecimal("tax"));
            sumamount = sumamount.add(row.getBigDecimal("amount"));
            sumtaxamount = sumtaxamount.add(row.getBigDecimal("taxamount"));
        }
        demandObj.set("sumtax", (Object)sumtax);
        demandObj.set("sumamount", (Object)sumamount);
        demandObj.set("sumtaxamount", (Object)sumtaxamount);
    }

    protected void updateDemandSceneEntry(DynamicObject demandObj, DynamicObject[] materialRows) {
        DynamicObjectCollection sceneRows = demandObj.getDynamicObjectCollection("entry");
        for (DynamicObject sceneRow : sceneRows) {
            this.updateDemandSceneAmount(sceneRow, materialRows);
            this.updateProjectSceneAmount(sceneRow);
        }
    }

    protected void updateDemandSceneAmount(DynamicObject sceneRow, DynamicObject[] materialRows) {
        BigDecimal sceneamount = BigDecimal.ZERO;
        BigDecimal scenetaxamount = BigDecimal.ZERO;
        Set idSet = MultiBasedataUtils.getBasedataIdSet((DynamicObject)sceneRow, (String)"decisionitem");
        List rows = Arrays.asList(materialRows).stream().filter(e -> idSet.contains(e.getLong("id"))).collect(Collectors.toList());
        for (DynamicObject row : rows) {
            sceneamount = sceneamount.add(row.getBigDecimal("amount"));
            scenetaxamount = scenetaxamount.add(row.getBigDecimal("taxamount"));
        }
        sceneRow.set("sceneamount", (Object)sceneamount);
        sceneRow.set("scenetaxamount", (Object)scenetaxamount);
    }

    protected void updateProjectSceneAmount(DynamicObject sceneRow) {
        String projectno = sceneRow.getString("projectno");
        if (StringUtils.isBlank((CharSequence)projectno)) {
            return;
        }
        QFilter qfilter = new QFilter("billno", "=", (Object)projectno);
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((String)"src_projectf7", (String)"sceneamount,scenetaxamount", (QFilter[])qfilter.toArray());
        if (null == projectObj) {
            return;
        }
        projectObj.set("sceneamount", sceneRow.get("sceneamount"));
        projectObj.set("scenetaxamount", sceneRow.get("scenetaxamount"));
        PdsCommonUtils.saveDynamicObjects((DynamicObject)projectObj);
    }

    protected void updatePurlistEntry(Map<Long, DynamicObject> chgEntryMap, int amtprecision) {
        DynamicObject[] rows;
        String selectFields = "sourceentryid,qty,tax,amount,taxamount,material,unit,baseunit,baseqty";
        Set sourceEntryIds = chgEntryMap.keySet().stream().map(e -> PdsCommonUtils.object2String((Object)e, (String)"")).collect(Collectors.toSet());
        QFilter qfilters = new QFilter("sourceentryid", "in", sourceEntryIds);
        for (DynamicObject row : rows = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilters.toArray())) {
            DynamicObject chgObj = chgEntryMap.get(PdsCommonUtils.object2Long((Object)row.getString("sourceentryid")));
            if (null == chgObj) continue;
            this.setEntryValue(row, chgObj, amtprecision);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    protected void setEntryValue(DynamicObject row, DynamicObject chgObj, int amtprecision) {
        BigDecimal preQty = row.getBigDecimal("qty");
        BigDecimal newQty = chgObj.getBigDecimal("qty");
        BigDecimal tax = row.getBigDecimal("tax");
        BigDecimal amount = row.getBigDecimal("amount");
        BigDecimal taxAmount = row.getBigDecimal("taxamount");
        if (preQty.compareTo(BigDecimal.ZERO) > 0 && preQty.compareTo(newQty) != 0) {
            tax = tax.multiply(newQty).divide(preQty, amtprecision, RoundingMode.HALF_DOWN);
            amount = amount.multiply(newQty).divide(preQty, amtprecision, RoundingMode.HALF_DOWN);
            taxAmount = taxAmount.multiply(newQty).divide(preQty, amtprecision, RoundingMode.HALF_DOWN);
        }
        row.set("qty", (Object)chgObj.getBigDecimal("qty"));
        row.set("tax", (Object)tax);
        row.set("amount", (Object)amount);
        row.set("taxamount", (Object)taxAmount);
        String name = row.getDynamicObjectType().getName();
        if (Objects.equals(name, "src_demandf7two")) {
            row.set("baseqty", (Object)CommonUtil.getDesQtyConv((DynamicObject)row.getDynamicObject("material1"), (DynamicObject)row.getDynamicObject("unit2"), (BigDecimal)chgObj.getBigDecimal("qty"), (DynamicObject)row.getDynamicObject("baseunit")));
        } else if (Objects.equals(name, "src_purlistf7")) {
            row.set("baseqty", (Object)CommonUtil.getDesQtyConv((DynamicObject)row.getDynamicObject("material"), (DynamicObject)row.getDynamicObject("unit"), (BigDecimal)chgObj.getBigDecimal("qty"), (DynamicObject)row.getDynamicObject("baseunit")));
        }
    }

    private Map<Long, DynamicObject> getChgEntryMap(DynamicObject bidChangeObj) {
        DynamicObject qtyChgObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_demandqtychg");
        if (null == qtyChgObj) {
            return null;
        }
        DynamicObjectCollection rows = qtyChgObj.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return null;
        }
        Map<Long, DynamicObject> chgEntryMap = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("material.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        return chgEntryMap;
    }

    private void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

