/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.calc.SrcCalcHelper;

public class SrcMaterialChgHandleService
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj.getDynamicObject("project"));
        DynamicObject newMaterialObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_materialchg");
        if (null == newMaterialObj) {
            return result;
        }
        DynamicObjectCollection newMaterialRows = newMaterialObj.getDynamicObjectCollection("entryentity");
        List<DynamicObject> newMaterialList = newMaterialRows.stream().filter(e -> e.getBoolean("ischanged") && e.getLong("srcentryid.id") > 0L).collect(Collectors.toList());
        if (newMaterialList == null || newMaterialList.size() == 0) {
            return result;
        }
        List propertys = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)((DynamicObject)newMaterialList.get(0)));
        this.updateMaterialInfo(newMaterialList, "src_purlistf7", propertys, projectId);
        this.updateMaterialInfo(newMaterialList, "src_contractentry", propertys, projectId);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcMaterialChgHandleService_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        return result;
    }

    protected void updateMaterialInfo(List<DynamicObject> newMaterialList, String entityName, List<String> propertys, long projectId) {
        QFilter purlistfilter;
        Set srcEntryIds = newMaterialList.stream().map(e -> e.getLong("srcentryid.id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> entryMap = newMaterialList.stream().collect(Collectors.groupingBy(e -> e.getLong("srcentryid.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        QFilter qfilter = new QFilter("purlist", "in", srcEntryIds);
        qfilter.or("id", "in", srcEntryIds);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)false);
        DynamicObject[] targetObjs = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilter.toArray());
        HashSet<String> specialFields = new HashSet<String>(4);
        specialFields.add("srcentryid");
        specialFields.add("ischanged");
        specialFields.add("seq");
        specialFields.add("supplier");
        specialFields.add("isnew");
        specialFields.add("billtype");
        boolean isCalculateAmount = false;
        for (DynamicObject targetObj : targetObjs) {
            long key = 0L;
            key = targetObj.getBoolean("isnew") ? targetObj.getLong("id") : targetObj.getLong("purlist.id");
            DynamicObject sourceObj = entryMap.get(key);
            if (null == sourceObj) continue;
            isCalculateAmount = this.calculateAmount(propertys, sourceObj, targetObj);
            this.setEntryValue(sourceObj, targetObj, propertys, specialFields);
            if (!"src_purlistf7".equals(entityName)) continue;
            this.cleanOtherValue(targetObj);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])targetObjs);
        if ("src_purlistf7".equals(entityName) && isCalculateAmount && QueryServiceHelper.exists((String)"src_purlistf7", (QFilter[])(purlistfilter = new QFilter("project", "=", (Object)projectId).and("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue())).toArray())) {
            SrcCalcHelper.syntheticalCalculate("src_compare", projectId);
        }
    }

    private void cleanOtherValue(DynamicObject targetObj) {
        targetObj.set("price2", (Object)0);
        targetObj.set("price3", (Object)0);
        targetObj.set("price12", (Object)0);
        targetObj.set("price13", (Object)0);
        targetObj.set("price14", (Object)0);
        targetObj.set("price15", (Object)0);
    }

    protected boolean calculateAmount(List<String> propertys, DynamicObject sourceObj, DynamicObject targetObj) {
        if (propertys.contains("qty")) {
            BigDecimal newQty = sourceObj.getBigDecimal("qty");
            BigDecimal oldQty = targetObj.getBigDecimal("qty");
            BigDecimal percentage = BigDecimal.ONE;
            if (newQty.compareTo(BigDecimal.ZERO) > 0 && oldQty.compareTo(newQty) != 0) {
                int scale = this.getAmtPrecision(targetObj);
                percentage = oldQty.compareTo(BigDecimal.ZERO) == 0 ? newQty : newQty.divide(oldQty, 10, RoundingMode.HALF_DOWN);
                this.setNewValue(targetObj, "amount", percentage, scale);
                this.setNewValue(targetObj, "tax", percentage, scale);
                this.setNewValue(targetObj, "taxamount", percentage, scale);
                this.setNewValue(targetObj, "locamount", percentage, scale);
                this.setNewValue(targetObj, "loctaxamount", percentage, scale);
                return true;
            }
        }
        return false;
    }

    protected void setEntryValue(DynamicObject sourceObj, DynamicObject targetObj, List<String> propertys, Set<String> specialFields) {
        for (String property : propertys) {
            DynamicProperty dyProperty;
            if (specialFields.contains(property) || null == (dyProperty = targetObj.getDynamicObjectType().getProperty(property))) continue;
            Object obj = sourceObj.get(property);
            if (obj instanceof DynamicObject) {
                targetObj.set(property, ((DynamicObject)obj).getPkValue());
                continue;
            }
            if (obj instanceof DynamicObjectCollection) {
                targetObj.set(property, (Object)PdsCommonUtils.cloneCols((DynamicObject)sourceObj, (String)property));
                continue;
            }
            targetObj.set(property, obj);
        }
    }

    protected int getAmtPrecision(DynamicObject purlistObj) {
        int amtPrecision = 6;
        Object currencyObj = purlistObj.get("currency");
        if (currencyObj instanceof DynamicObject) {
            DynamicObject currency = (DynamicObject)currencyObj;
            amtPrecision = currency.getInt("amtprecision");
        }
        return amtPrecision;
    }

    private void setNewValue(DynamicObject targetObj, String fieldName, BigDecimal percentage, int scale) {
        BigDecimal newValue = targetObj.getBigDecimal(fieldName).multiply(percentage).setScale(scale, 4);
        targetObj.set(fieldName, (Object)newValue);
    }
}

