/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;
import kd.scm.src.common.util.SrcNegotiateChangeUtils;

public class SrcNegotiateDeadlineChgService
implements IDataHandleService {
    public HandleResult handle(HandleEvent handleEvent) {
        String message = ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u53d8\u66f4\u5931\u8d25\u3002", (String)"SrcNegotiateDeadlineChgService_0", (String)"scm-src-common", (Object[])new Object[0]);
        HandleResult result = new HandleResult();
        result.setSuccess(false);
        DynamicObject bidChangeObj = handleEvent.getObj();
        DynamicObject compDataObj = TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)"src_negotiate_timechg");
        Date deadline = compDataObj.getDate("deadline");
        long negotiateId = SrmCommonUtil.getPkValue((DynamicObject)compDataObj.getDynamicObject("negotiate"));
        DynamicObject negotiateObj = BusinessDataServiceHelper.loadSingle((Object)negotiateId, (String)"src_negotiatebill");
        this.updateDeadline(negotiateObj, deadline);
        result.setSuccess(true);
        message = ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u53d8\u66f4\u6210\u529f\u3002", (String)"SrcNegotiateDeadlineChgService_1", (String)"scm-src-common", (Object[])new Object[0]);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    private void updateDeadline(DynamicObject negotiateObj, Date deadline) {
        DynamicObject[] quotebillObjs;
        long projectId = negotiateObj.getLong("project.id");
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((String)"src_projectf7", (String)"stopbiddate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
        projectObj.set("stopbiddate", (Object)deadline);
        negotiateObj.set("deadline", (Object)deadline);
        for (DynamicObject quotebillObj : quotebillObjs = SrcNegotiateChangeUtils.getQuotebillObjs(negotiateObj)) {
            quotebillObj.set("deadline", (Object)deadline);
        }
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectObj});
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{negotiateObj});
                SaveServiceHelper.save((DynamicObject[])quotebillObjs);
            }
            catch (Exception e) {
                h.markRollback();
                throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }

    public void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

