/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.util.TemplateUtil;

public class SrcProjectManChgService
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        String message = ResManager.loadKDString((String)"\u9879\u76ee\u6210\u5458\u53d8\u66f4\u5931\u8d25\u3002", (String)"SrcProjectManChgService_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(false);
        result.setMessage(message);
        DynamicObject chgObj = handleEvent.getObj();
        DynamicObject proManChgObj = TemplateUtil.getCompData((DynamicObject)chgObj, (String)"src_projectman_chg");
        this.updateProjectCreator(chgObj, proManChgObj);
        this.updateBidder(chgObj, proManChgObj);
        message = ResManager.loadKDString((String)"\u9879\u76ee\u6210\u5458\u53d8\u66f4\u6210\u529f\u3002", (String)"SrcProjectManChgService_1", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        return result;
    }

    private void updateBidder(DynamicObject chgObj, DynamicObject proManChgObj) {
        DynamicObjectCollection rows = proManChgObj.getDynamicObjectCollection("entryentity");
        Map<Long, DynamicObject> manMap = rows.stream().filter(obj -> Objects.nonNull(obj.getDynamicObject("newbidder"))).collect(Collectors.toMap(obj -> Optional.ofNullable(obj.getString("srcentryid")).map(Long::parseLong).orElse(0L), obj -> obj));
        DynamicObject projectManObj = TemplateUtil.getComponentData((String)String.valueOf(chgObj.getDynamicObject("project").getLong("id")), (String)"src_project_man");
        DynamicObjectCollection entryentity = projectManObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            DynamicObject manObj = manMap.get(entry.get("id"));
            if (null == manObj) continue;
            DynamicObject newBidder = manObj.getDynamicObject("newbidder");
            entry.set("bidder", (Object)newBidder);
            entry.set("number", newBidder.get("number"));
            DynamicObjectCollection bidderCols = newBidder.getDynamicObjectCollection("entryentity");
            if (bidderCols.size() > 0) {
                entry.set("dept", ((DynamicObject)bidderCols.get(0)).get("dpt"));
                entry.set("position", ((DynamicObject)bidderCols.get(0)).get("position"));
            }
            entry.set("phone", newBidder.get("phone"));
            entry.set("email", newBidder.get("email"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectManObj});
    }

    private void updateProjectCreator(DynamicObject chgObj, DynamicObject proManChgObj) {
        DynamicObject newProjectCreator = proManChgObj.getDynamicObject("newprojectcreator");
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)SrmCommonUtil.getPkValue((DynamicObject)chgObj.getDynamicObject("project")), (String)"src_project");
        if (Objects.nonNull(newProjectCreator)) {
            projectObj.set("projectcreator", (Object)newProjectCreator);
            projectObj.set("creator", (Object)newProjectCreator);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectObj});
    }
}

