/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcSupplierInvalidPayment
implements IDataHandleService {
    private static final long serialVersionUID = 8634249315457733232L;

    public HandleResult handle(HandleEvent handleEvent) {
        String message = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5e9f\u6807\uff1a\u6309\u6807\u6bb5\u5e9f\u6807\u6536\u8d39\u660e\u7ec6\u5931\u8d25\u3002", (String)"SrcSupplierInvalidPayment_0", (String)"scm-src-common", (Object[])new Object[0]);
        HandleResult result = new HandleResult();
        result.setSuccess(false);
        this.invalidPayment(handleEvent.getObj());
        result.setSuccess(true);
        message = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5e9f\u6807\uff1a\u6309\u6807\u6bb5\u5e9f\u6807\u6536\u8d39\u660e\u7ec6\u6210\u529f\u3002", (String)"SrcSupplierInvalidPayment_1", (String)"scm-src-common", (Object[])new Object[0]);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    protected void invalidPayment(DynamicObject bidChangeObj) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj.getDynamicObject("project"));
        boolean ismultipackage = bidChangeObj.getDynamicObject("project").getBoolean("ismultipackage");
        DynamicObject compDataObj = TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)"src_supplierinvalid");
        DynamicObjectCollection rows = compDataObj.getDynamicObjectCollection("entryentity");
        List discardList = rows.stream().filter(e -> e.getBoolean("isdiscard")).collect(Collectors.toList());
        Set supplierIds = discardList.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("supplier", "in", supplierIds);
        DynamicObject[] paymentObjs = BusinessDataServiceHelper.load((String)"src_payment", (String)"suppliertype,supplier,package,paystatus,entrystatus,feeway", (QFilter[])qfilter.toArray());
        if (null == paymentObjs || paymentObjs.length == 0) {
            return;
        }
        String feeWay = paymentObjs[0].getString("feeway.number");
        ArrayList<DynamicObject> paymentList = new ArrayList<DynamicObject>(paymentObjs.length);
        for (DynamicObject row : discardList) {
            long supplierId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("supplier"));
            long packageId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("package"));
            List objs = Objects.equals("C020702", feeWay) ? Arrays.stream(paymentObjs).filter(e -> e.getLong("supplier.id") == supplierId).collect(Collectors.toList()) : (ismultipackage ? Arrays.stream(paymentObjs).filter(e -> e.getLong("supplier.id") == supplierId && e.getLong("package.id") == packageId).collect(Collectors.toList()) : Arrays.stream(paymentObjs).filter(e -> e.getLong("supplier.id") == supplierId).collect(Collectors.toList()));
            if (objs.size() == 0) continue;
            for (DynamicObject obj : objs) {
                if (!this.isAllPackageInvalid(ismultipackage, obj, rows, feeWay, packageId)) continue;
                obj.set("entrystatus", (Object)BillStatusEnum.AUDIT.getVal());
                obj.set("paystatus", (Object)ProjectStatusEnums.INVALID.getValue());
                paymentList.add(obj);
            }
        }
        PdsCommonUtils.saveDynamicObjects(paymentList);
    }

    public void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }

    protected boolean isAllPackageInvalid(boolean isMultiPackage, DynamicObject billObj, DynamicObjectCollection rows, String feeWay, long packageId) {
        if (!isMultiPackage) {
            return true;
        }
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("supplier"));
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("supplier"));
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        qfilter.and("supplier", "=", (Object)supplierId);
        qfilter.and("isdiscard", "=", (Object)"0");
        if (Objects.equals("C020702", feeWay)) {
            if (rows.stream().anyMatch(e -> e.getLong("supplier.id") == supplierId && !e.getBoolean("isdiscard"))) {
                return false;
            }
        } else {
            if (rows.stream().anyMatch(e -> e.getLong("supplier.id") == supplierId && Objects.equals(packageId, e.getLong("package.id")) && !e.getBoolean("isdiscard"))) {
                return false;
            }
            qfilter.and("package", "=", (Object)packageId);
        }
        return !QueryServiceHelper.exists((String)"src_bidopensupplier", (QFilter[])qfilter.toArray());
    }
}

