/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.comptpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.ValidateResult;
import kd.scm.pds.common.comptpl.PdsCompTplContext;
import kd.scm.pds.common.comptpl.PdsCompTplServiceImpl;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.change.SrcDataHandleFactory;
import kd.scm.src.common.change.SrcDataValidateFactory;
import kd.scm.src.common.util.SrcBidChangeUtil;
import kd.scm.src.common.util.SrcProjectUtil;

public class SrcBidChangeCompTplServiceImpl
extends PdsCompTplServiceImpl {
    public boolean isShowComponent(String compKey) {
        String manageType = this.getModel().getDataEntity().getString("project.managetype");
        switch (compKey) {
            case "src_invitesupplier_chg": {
                return !"3".equals(manageType);
            }
            case "src_itemsupplier_chg": {
                return "3".equals(manageType);
            }
        }
        return super.isShowComponent(compKey);
    }

    public void propertyChanged(PdsCompTplContext context) {
        super.propertyChanged(context);
        PropertyChangedArgs e = context.getPropertyChangeArgs();
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newVal = changeSet[0].getNewValue();
        switch (proName) {
            case "apply": 
            case "demand": 
            case "project": {
                this.loadEntryData((DynamicObject)newVal, this.getModel().getDataEntity().getDynamicObject("template"));
                this.getView().invokeOperation("refreshcomp");
                break;
            }
            case "template": {
                this.loadEntryData(SrcBidChangeUtil.getBidChangeObject(this.getModel()), (DynamicObject)newVal);
                break;
            }
        }
    }

    public void loadEntryData(DynamicObject changeObj, DynamicObject chgeType) {
        if (changeObj == null || chgeType == null || SrmCommonUtil.getPkValue((DynamicObject)changeObj) == 0L || SrmCommonUtil.getPkValue((DynamicObject)chgeType) == 0L) {
            this.clearEntryData();
            return;
        }
        List<Long> nodeIds = new ArrayList<Long>();
        String changeSource = PdsCommonUtils.object2String((Object)this.getModel().getValue("changesource"), (String)"3");
        if (changeSource.equals("1")) {
            nodeIds.add(PdsCommonUtils.getBasedataIdByNumber((String)"pds_biznode", (String)PdsBizNodeEnums.SRCAPPLY.getValue()));
        } else if (changeSource.equals("2")) {
            nodeIds.add(PdsCommonUtils.getBasedataIdByNumber((String)"pds_biznode", (String)PdsBizNodeEnums.DEMAND.getValue()));
        } else if ("src_batchdecision".equals(this.getView().getEntityId())) {
            nodeIds.add(PdsCommonUtils.getBasedataIdByNumber((String)"pds_biznode", (String)PdsBizNodeEnums.BATCHDECISION.getValue()));
        } else {
            List<DynamicObject> childNodes = SrcProjectUtil.getHandledBizNodes(this.getProjectObj(changeObj));
            nodeIds = DynamicObjectUtil.array2ListId((DynamicObject[])childNodes.toArray(new DynamicObject[0]), (String)"id");
        }
        DynamicObjectCollection conditionObjs = SrcBidChangeUtil.getCondtionObjs(nodeIds, chgeType);
        this.createEntryData("validateentry", "condition", conditionObjs);
        DynamicObjectCollection handleObjs = SrcBidChangeUtil.getHandleObjs(nodeIds, chgeType);
        this.createEntryData("handleentry", "handler", handleObjs);
    }

    public void beforeDoOperation(PdsCompTplContext context) {
        String operateKey;
        this.initParam(context);
        BeforeDoOperationEventArgs evt = context.getBeforeDoOperationEventArgs();
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": {
                if (!this.continueDoOpByLoadedComp(evt)) break;
                this.verifyBeforeSave(evt);
                break;
            }
            case "submit": {
                if (!this.continueDoOpByLoadedComp(evt)) break;
                this.verifyBeforeSubmit(evt);
                break;
            }
        }
        if (evt.isCancel()) {
            return;
        }
        super.beforeDoOperation(context);
    }

    public void verifyBeforeSave(BeforeDoOperationEventArgs evt) {
        DynamicObject bidChangeObj = SrcBidChangeUtil.getBidChangeObject(this.getModel());
        if (null == bidChangeObj) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u5fc5\u5f55\u9879\u3002", (String)"SrcBidChangeCompTplServiceImpl_5", (String)"scm-src-common", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    public void verifyBeforeSubmit(BeforeDoOperationEventArgs evt) {
        DynamicObject bidChangeObj = SrcBidChangeUtil.getBidChangeObject(this.getModel());
        if (null == bidChangeObj) {
            evt.setCancel(true);
            return;
        }
        this.verifyExistOtherUnAudit(evt);
        if (evt.isCancel()) {
            return;
        }
        this.verifyChangeCondition(evt);
        if (evt.isCancel()) {
            return;
        }
        this.verifyChangeHandle(evt);
        if (evt.isCancel()) {
            return;
        }
        this.doValidate(evt);
        if (evt.isCancel()) {
            return;
        }
    }

    public void verifyChangeCondition(BeforeDoOperationEventArgs evt) {
        SrcDataValidateFactory validateFactory = new SrcDataValidateFactory(this.getModel().getDataEntity(true));
        if (validateFactory.getPluginList().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53d8\u66f4\u5224\u65ad\u6761\u4ef6\uff0c\u8bf7\u5148\u5230\u5bfb\u6e90\u53d8\u66f4\u6761\u4ef6\u4e2d\u6ce8\u518c\u53d8\u66f4\u6761\u4ef6\u3002", (String)"SrcBidChangeCompTplServiceImpl_0", (String)"scm-src-common", (Object[])new Object[0]));
        }
    }

    public void verifyChangeHandle(BeforeDoOperationEventArgs evt) {
        SrcDataHandleFactory handleFactory = new SrcDataHandleFactory(this.getModel().getDataEntity(true));
        if (handleFactory.getPluginList().size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53d8\u66f4\u5904\u7406\u903b\u8f91\uff0c\u8bf7\u5148\u5230\u5bfb\u6e90\u53d8\u66f4\u903b\u8f91\u4e2d\u6ce8\u518c\u53d8\u66f4\u903b\u8f91\u3002", (String)"SrcBidChangeCompTplServiceImpl_1", (String)"scm-src-common", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void doValidate(BeforeDoOperationEventArgs evt) {
        DynamicObject bidChangeObj = this.getModel().getDataEntity(true);
        SrcDataValidateFactory validateFactory = new SrcDataValidateFactory(bidChangeObj);
        Map<String, Object> compKey_objMap = this.getCompKeyDataMap(bidChangeObj);
        validateFactory.getValidateEvent().setParams(compKey_objMap);
        ValidateResult validateResult = validateFactory.doValidate();
        if (!validateResult.isSuccess()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53d8\u66f4\u6761\u4ef6\u6821\u9a8c\u672a\u901a\u8fc7,\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"SrcBidChangeCompTplServiceImpl_2", (String)"scm-src-common", (Object[])new Object[0]), validateResult.getMessage(), MessageTypes.Default);
            evt.setCancel(true);
        }
    }

    public void verifyExistOtherUnAudit(BeforeDoOperationEventArgs evt) {
        String key = SrcBidChangeUtil.getBidChangeObjectKey(this.getModel());
        DynamicObject bidChangeObj = SrcBidChangeUtil.getBidChangeObject(this.getModel());
        long keyValue = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj);
        QFilter qfilter = new QFilter(key, "=", (Object)keyValue);
        qfilter.and("id", "!=", (Object)SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity()));
        qfilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getVal());
        qfilter.and("supplier", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity().getDynamicObject("supplier")));
        qfilter.and("template.biznode.number", "!=", (Object)PdsBizNodeEnums.BATCHDECISION.getValue());
        if (QueryServiceHelper.exists((String)"src_bidchange", (QFilter[])qfilter.toArray())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u672a\u5904\u7406\u7684\u53d8\u66f4\u5355\u636e,\u4e0d\u5141\u8bb8\u518d\u63d0\u4ea4\u65b0\u7684\u53d8\u66f4\u5355\u3002", (String)"SrcBidChangeCompTplServiceImpl_6", (String)"scm-src-common", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public Map<String, Object> getCompKeyDataMap(DynamicObject bidChangeObj) {
        HashMap<String, Object> compKey_objMap = new HashMap<String, Object>(8);
        List compKeyList = TemplateUtil.getCompKeyList((DynamicObject)bidChangeObj);
        Set compKeySet = this.removeUnShowCompKey(compKeyList);
        for (String compKey : compKeySet) {
            String pageId = this.getPageCache().get(compKey);
            IFormView compView = SessionManager.getCurrent().getView(pageId);
            if (null == compView || null == compView.getModel()) continue;
            DynamicObject compObj = compView.getModel().getDataEntity(true);
            compKey_objMap.put(compKey, compObj);
        }
        return compKey_objMap;
    }

    public void clearEntryData() {
        this.getModel().deleteEntryData("validateentry");
        this.getModel().deleteEntryData("handleentry");
    }

    public void createEntryData(String entryKey, String pro, DynamicObjectCollection objs) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(entryKey);
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (DynamicObject obj : objs) {
            ts.set(pro, obj.get("id"), i);
            ++i;
        }
        model.batchCreateNewEntryRow(entryKey, ts);
    }

    public DynamicObject getProjectObj(DynamicObject project) {
        QFilter filter = new QFilter("id", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)project));
        String selectFields = "id,billno,template,entrymainflow.biznode,entrymainflow.flowbizstatus,entrysubflow.subbiznode,entrysubflow.subflowbizstatus,purdecision";
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((String)"src_project", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return projectObj;
    }
}

