/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.comptpl;

import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.BizLog;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.comptpl.PdsCompTplContext;
import kd.scm.pds.common.comptpl.PdsCompTplServiceImpl;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcPreDecisionCompTplServiceImpl
extends PdsCompTplServiceImpl {
    public void beforeDoOperation(PdsCompTplContext context) {
        String opKey;
        this.initParam(context);
        BeforeDoOperationEventArgs beforeDoOperation = context.getBeforeDoOperationEventArgs();
        switch (opKey = ((AbstractOperate)beforeDoOperation.getSource()).getOperateKey()) {
            case "calculate": 
            case "recalculate": 
            case "ratiocalculate": 
            case "addsupplier": 
            case "batchdecision": 
            case "allopen": 
            case "tecopen": 
            case "bizopen": {
                boolean isSuccess = this.doOperation("save");
                if (isSuccess) break;
                beforeDoOperation.setCancel(true);
                break;
            }
            default: {
                super.beforeDoOperation(context);
            }
        }
    }

    public boolean isDoCompOperation(String operateKey, String entityKey, boolean isAttach) {
        boolean isDoCompOperation = super.isDoCompOperation(operateKey, entityKey, isAttach);
        if (isAttach) {
            String pageId = this.getPageCache().get(entityKey);
            IFormView compView = SessionManager.getCurrent().getView(pageId);
            if (null != compView) {
                DynamicObject data = this.getModel().getDataEntity();
                DynamicObject sourceObj = data.getDynamicObject("sourceclass");
                if (null != sourceObj && Objects.equals("C011402", sourceObj.getString("number"))) {
                    isDoCompOperation = true;
                } else {
                    switch (operateKey) {
                        case "save": 
                        case "submit": {
                            SrcPurListUtil.writeBackSrcEntryData(compView, this.getView());
                            break;
                        }
                    }
                }
            }
        }
        return isDoCompOperation;
    }

    public boolean isShowComponent(String compKey) {
        String openStatus = this.getModel().getDataEntity().getString("openstatus");
        switch (compKey) {
            case "src_bidopen_tender": 
            case "src_tenderinfo_summary": 
            case "src_tender_quick": 
            case "src_tenderinfo": 
            case "src_biddiscard": {
                return PdsCommonUtils.isShowTenderBeforeBidOpen((DynamicObject)this.getModel().getDataEntity());
            }
            case "src_decision_result": {
                boolean isdecisionresult = this.getModel().getDataEntity().getBoolean("isdecisionresult");
                return isdecisionresult;
            }
            case "src_purlist_tieredprice": {
                String tieredType = this.getModel().getDataEntity().getString("tieredtype");
                if ("3".equals(tieredType)) {
                    return !BidOpenStatusEnums.NOOPEN.getValue().equals(openStatus) && !BidOpenStatusEnums.NOOPEN.getValue().equals(openStatus);
                }
                return false;
            }
            case "src_bidopen_open": {
                return !PdsCommonUtils.isOpenBySupplier((DynamicObject)this.getModel().getDataEntity());
            }
            case "src_supplier_open": {
                return PdsCommonUtils.isOpenBySupplier((DynamicObject)this.getModel().getDataEntity());
            }
            case "src_quotebillquery": 
            case "src_quotebill_attach": {
                return !BidOpenStatusEnums.NOOPEN.getValue().equals(openStatus) && !BidOpenStatusEnums.TECOPEN.getValue().equals(openStatus) && !BidOpenStatusEnums.NEGOTIATE.getValue().equals(openStatus);
            }
            case "src_purlist_item": {
                return PdsCommonUtils.isShowPurlistItemBeforeOpen((DynamicObject)this.getModel().getDataEntity());
            }
        }
        return super.isShowComponent(compKey);
    }

    public QFilter getCompQfilter(Object pkValue, String entityKey, String compKey) {
        QFilter filter = null;
        boolean isNeddFilterEntityKey = this.isNeedFilterEntityKey(entityKey, compKey);
        if (isNeddFilterEntityKey) {
            Set entityKeys = PdsCommonUtils.buildSet((String[])new String[]{"src_predecision", "src_decision"});
            filter = TemplateUtil.getComponentQfilter((Object)String.valueOf(pkValue), (Set)entityKeys, (String)compKey);
        } else {
            filter = TemplateUtil.getComponentQfilter((String)String.valueOf(pkValue), (String)compKey);
        }
        return filter;
    }

    public boolean isNeedFilterEntityKey(String entityKey, String compKey) {
        boolean isNeddFilterEntityKey = false;
        try {
            boolean isPurListComp;
            DynamicObject data = this.getModel().getDataEntity();
            DynamicObject sourceObj = data.getDynamicObject("sourceclass");
            if (null != sourceObj && Objects.equals("C011402", sourceObj.getString("number")) && (isPurListComp = SrcPurListUtil.isPurlistComp(this.getView(), this.getModel(), compKey))) {
                isNeddFilterEntityKey = true;
            }
        }
        catch (Exception e) {
            BizLog.log((String)e.getMessage());
        }
        return isNeddFilterEntityKey;
    }
}

