/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.contract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.src.common.contract.ISrcDecisonToContractHandler;
import kd.scm.src.common.contract.SrcContractHasPushValidator;
import kd.scm.src.common.contract.SrcDecisionContractHandlerAudit;
import kd.scm.src.common.contract.SrcDecisionContractHandlerUnAudit;

public class SrcContractUtils {
    public static void createContractEntry(ExtPluginContext context) {
        List<ISrcDecisonToContractHandler> auditHandlerInstances = SrcContractUtils.getAuditHandlerInstances();
        for (ISrcDecisonToContractHandler auditHandlerInstance : auditHandlerInstances) {
            auditHandlerInstance.process(context);
        }
    }

    public static List<ISrcDecisonToContractHandler> getAuditHandlerInstances() {
        return ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcDecisionContractHandlerAudit.class.getSimpleName(), SrcDecisionContractHandlerAudit.class.getName());
    }

    public static void deleteContractEntry(ExtPluginContext context) {
        List<ISrcDecisonToContractHandler> unAuditHandlerInstances = SrcContractUtils.getUnAuditHandlerInstances();
        for (ISrcDecisonToContractHandler unAuditHandlerInstance : unAuditHandlerInstances) {
            unAuditHandlerInstance.process(context);
        }
    }

    public static List<ISrcDecisonToContractHandler> getUnAuditHandlerInstances() {
        return ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcDecisionContractHandlerUnAudit.class.getSimpleName(), SrcDecisionContractHandlerUnAudit.class.getName());
    }

    public static String contractHasPush(DynamicObject billObj) {
        List validators = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcContractHasPushValidator.class.getSimpleName(), SrcContractHasPushValidator.class.getName());
        if (null == validators || validators.size() == 0) {
            return null;
        }
        SrcValidatorData context = new SrcValidatorData();
        context.setBillObj(billObj);
        context.setSucced(true);
        for (ISrcValidator validator : validators) {
            validator.validate(context);
        }
        if (context.isSucced()) {
            return null;
        }
        return context.getMessage();
    }

    private static boolean isExistsMaterialPurchaseInfo(long materialId, long orgId) {
        QFilter masterFilter = new QFilter("masterid", "=", (Object)materialId);
        QFilter strategyFilter = BaseDataServiceHelper.getBaseDataFilter((String)FormMetadataCache.getFormConfig((String)"bd_materialpurchaseinfo").getEntityTypeId(), (Long)orgId);
        BizLog.log((String)("SrcContractUtils query materialpurchaseinfo filter:" + strategyFilter.and(masterFilter).toString()));
        return QueryServiceHelper.exists((String)"bd_materialpurchaseinfo", (QFilter[])new QFilter[]{strategyFilter.and(masterFilter)});
    }

    public static void isExistsMaterialPurchaseInfoByEdit(IDataModel iDataModel, IFormView iFormView, BeforeDoOperationEventArgs args) {
        long orgId = iDataModel.getDataEntity().getLong("org.id");
        DynamicObjectCollection rows = iDataModel.getEntryEntity("entryentity");
        HashSet<Integer> indexSet = new HashSet<Integer>(16);
        for (int i = 0; i < rows.size(); ++i) {
            boolean exists = SrcContractUtils.isExistsMaterialPurchaseInfo(((DynamicObject)rows.get(i)).getLong("material.id"), orgId);
            if (exists) continue;
            indexSet.add(i + 1);
        }
        SrcContractUtils.showMessage(indexSet, iFormView, args);
    }

    public static void isExistsMaterialPurchaseInfoByList(IFormView iFormView, BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        HashSet<Integer> indexSet = new HashSet<Integer>(16);
        int i = 1;
        for (ListSelectedRow selectedRow : listSelectedData) {
            DynamicObject contractEntry = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getEntryPrimaryKeyValue(), (String)"src_contractentry");
            boolean exists = SrcContractUtils.isExistsMaterialPurchaseInfo(contractEntry.getLong("material.id"), contractEntry.getLong("entry_org.id"));
            if (!exists) {
                indexSet.add(i);
            }
            ++i;
        }
        SrcContractUtils.showMessage(indexSet, iFormView, args);
    }

    public static void isExistsMaterialPurchaseInfoByEntryIds(IDataModel iDataModel, IFormView iFormView, BeforeDoOperationEventArgs args) {
        EntryGrid grid = (EntryGrid)iFormView.getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            SrcContractUtils.isExistsMaterialPurchaseInfoByEdit(iDataModel, iFormView, args);
            return;
        }
        long orgId = iDataModel.getDataEntity().getLong("org.id");
        DynamicObjectCollection entries = iDataModel.getEntryEntity("entryentity");
        HashSet<Integer> indexSet = new HashSet<Integer>(16);
        for (int selectRow : selectRows) {
            boolean exists = SrcContractUtils.isExistsMaterialPurchaseInfo(((DynamicObject)entries.get(selectRow)).getLong("material.id"), orgId);
            if (exists) continue;
            indexSet.add(selectRow + 1);
        }
        SrcContractUtils.showMessage(indexSet, iFormView, args);
    }

    public static String isExistsMaterialPurchaseInfoByEdit(DynamicObjectCollection rows, long orgId) {
        HashSet<Integer> indexSet = new HashSet<Integer>(16);
        for (DynamicObject row : rows) {
            int seq = row.getInt("seq");
            boolean exists = SrcContractUtils.isExistsMaterialPurchaseInfo(row.getLong("material.id"), orgId);
            if (exists) continue;
            indexSet.add(seq);
        }
        return indexSet.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    private static void showMessage(Set<Integer> indexSet, IFormView iFormView, BeforeDoOperationEventArgs args) {
        if (!CollectionUtils.isEmpty(indexSet)) {
            String indexStr = indexSet.stream().map(String::valueOf).collect(Collectors.joining(","));
            iFormView.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7269\u6599\u5728\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u7ef4\u62a4\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u518d\u4e0b\u63a8\u4e0b\u6e38\u5355\u636e\u3002", (String)"SrcContractUtils_0", (String)"scm-src-common", (Object[])new Object[0]), indexStr));
            args.setCancel(true);
        }
    }

    public static void setGenerateVisible(IFormView iFormView) {
        String connectErp;
        iFormView.setVisible(Boolean.valueOf(false), new String[]{"xh_generate"});
        switch (connectErp = PdsCommonUtils.getConnectErp()) {
            case "0": {
                iFormView.setVisible(Boolean.valueOf(true), new String[]{"xh_generate"});
                break;
            }
        }
    }

    public static void setCurrentNodeStatus(DynamicObject billObj, String operationKey) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"src", (String)"SrcContractBillService", (String)"executeOperate", (Object[])new Object[]{billObj, operationKey});
        if (CollectionUtils.isEmpty((Map)result)) {
            return;
        }
        billObj.set("currentnode", result.get("currNodeId"));
        DynamicObject currNode = (DynamicObject)result.get("currNode");
        if (null == currNode) {
            return;
        }
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entrymainflow");
        for (DynamicObject row : rows) {
            if (!Objects.equals(row.getPkValue(), currNode.getPkValue())) continue;
            row.set("flowbizstatus", currNode.get("flowbizstatus"));
            row.set("flowbillstatus", currNode.get("flowbillstatus"));
            break;
        }
    }

    public static DynamicObjectCollection getSelectRows(IFormView view, IDataModel model, DynamicObjectCollection entryentity, List<ListSelectedRow> selectedRowList) {
        DynamicObjectCollection rows = new DynamicObjectCollection();
        EntryGrid grid = (EntryGrid)view.getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        HashMap<Integer, DynamicObject> selectMap = new HashMap<Integer, DynamicObject>(selectRows.length);
        for (int value : selectRows) {
            selectMap.put(value, model.getEntryRowEntity("entryentity", value));
        }
        boolean isSelect = false;
        if (selectRows.length > 0) {
            isSelect = true;
        }
        if (!isSelect) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue(view.getModel().getDataEntity().getPkValue());
            row.setEntryEntityKey("entryentity");
            selectedRowList.add(row);
            rows = entryentity;
        }
        if (isSelect) {
            for (int selectRow : selectRows) {
                DynamicObject obj = (DynamicObject)selectMap.get(selectRow);
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(view.getModel().getDataEntity().getPkValue());
                row.setEntryEntityKey("entryentity");
                row.setEntryPrimaryKeyValue(obj.getPkValue());
                selectedRowList.add(row);
                rows.add((Object)obj);
            }
        }
        return rows;
    }

    public static String getEmptyMaterialIndex(DynamicObjectCollection rows) {
        List materialIdList = rows.stream().filter(e -> e.getLong("material.id") == 0L).collect(Collectors.toList());
        if (materialIdList.size() == 0) {
            return "";
        }
        Set materialIdSet = materialIdList.stream().map(e -> e.getInt("seq")).collect(Collectors.toSet());
        return materialIdSet.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    public static String getPotentialSupplierIndex(DynamicObjectCollection rows, StringBuilder sb) {
        Map<Long, List<DynamicObject>> supplierIdMap = rows.stream().collect(Collectors.groupingBy(e -> e.getLong("supplier.id")));
        QFilter qfilter = new QFilter("id", "in", supplierIdMap.keySet());
        qfilter.and("supplier_status_id", "=", (Object)880835238786237440L);
        DynamicObjectCollection supRows = QueryServiceHelper.query((String)"bd_supplier", (String)"id", (QFilter[])qfilter.toArray());
        if (supRows.size() == 0) {
            return "";
        }
        ArrayList supList = new ArrayList(rows.size());
        for (DynamicObject row : supRows) {
            supList.addAll(supplierIdMap.get(row.getLong("id")));
        }
        Set supSet = supList.stream().map(e -> e.getInt("seq")).collect(Collectors.toSet());
        return supSet.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    public static ConvertOperationResult pushBill(List<ListSelectedRow> selectedRowList, String srcBill, String tarBill) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcBill);
        pushArgs.setTargetEntityNumber(tarBill);
        pushArgs.setBuildConvReport(false);
        pushArgs.setSelectedRows(selectedRowList);
        pushArgs.setAutoSave(true);
        pushArgs.setShowReport(true);
        pushArgs.setBuildConvReport(true);
        return ConvertServiceHelper.push((PushArgs)pushArgs);
    }
}

