/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.copycompdata.comm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.EntryGrid;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.src.common.copycompdata.SrcCopyCompDataUtils;

public class SrcCopyCompCreateCompEntry
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.createCompEntry(context);
    }

    private void createCompEntry(ExtPluginContext context) {
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        model.deleteEntryData("entryentity");
        DynamicObject projectObj = context.getView().getModel().getDataEntity().getDynamicObject("project");
        if (null == projectObj) {
            return;
        }
        long projectId = projectObj.getLong("id");
        if (projectId == 0L) {
            return;
        }
        List<String> compKeyList = SrcCopyCompDataUtils.getValidCompKeyList(projectObj);
        DynamicObject sourceObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project");
        DynamicObjectCollection compRows = sourceObj.getDynamicObjectCollection("tplentry");
        Map<String, DynamicObject> compKeyMap = compRows.stream().filter(e -> !StringUtils.isBlank((CharSequence)e.getString("tmp_bizobject"))).collect(Collectors.groupingBy(e -> e.getString("tmp_bizobject"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        model.beginInit();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        ArrayList<Integer> indexList = new ArrayList<Integer>(compKeyList.size());
        for (String compKey : compKeyList) {
            DynamicObject compRow = compKeyMap.get(compKey);
            if (null == compRow) continue;
            ts.set("tmp_template", (Object)compRow.getLong("tmp_template.id"), index);
            ts.set("tmp_component", (Object)compRow.getLong("tmp_component.id"), index);
            ts.set("tmp_bizobject", (Object)compRow.getString("tmp_bizobject"), index);
            indexList.add(index);
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
        model.endInit();
        context.getView().updateView("entryentity");
        int[] selectIndexs = indexList.stream().mapToInt(Integer::intValue).toArray();
        EntryGrid entryGrid = (EntryGrid)context.getView().getControl("entryentity");
        entryGrid.selectRows(selectIndexs, 0);
    }
}

