/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class SrcScoreTaskMsgToTecScorer
implements IEventServicePlugin {
    public Map<String, List<Long>> calculateUserIds(KDBizEvent evt) {
        DynamicObject[] configObjs;
        HashMap<String, List<Long>> userIdMaps = new HashMap<String, List<Long>>(16);
        List billIds = ((EntityEvent)evt).getBusinesskeys();
        for (DynamicObject configObj : configObjs = BusinessDataServiceHelper.load((Object[])billIds.stream().map(Long::parseLong).toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"src_bidopen_config").getDynamicObjectType())) {
            DynamicObjectCollection rows = configObj.getDynamicObjectCollection("entryentity");
            HashSet userIds = new HashSet(16);
            rows.stream().filter(row -> !Objects.equals(row.getString("entrystatus"), "A")).filter(row -> Objects.equals(row.getString("indextype.basetype"), "1") || Objects.equals(row.getString("indextype.basetype"), "3")).forEach(row -> {
                DynamicObjectCollection scorers = row.getDynamicObjectCollection("scorer");
                userIds.addAll(scorers.stream().map(scorer -> scorer.getLong("fbasedataid.id")).collect(Collectors.toList()));
            });
            userIdMaps.put(configObj.getPkValue().toString(), new ArrayList(userIds));
        }
        return userIdMaps;
    }

    public Map<String, String> buildBillUrl(KDBizEvent evt) {
        String baseType;
        String operation;
        switch (operation = ((EntityEvent)evt).getOperation()) {
            case "aptitudeauditsendmsg": {
                baseType = "4";
                break;
            }
            case "aptitudeaudit2sendmsg": {
                baseType = "7";
                break;
            }
            default: {
                baseType = "";
            }
        }
        List billIds = ((EntityEvent)evt).getBusinesskeys();
        HashMap<String, String> urlMaps = new HashMap<String, String>(16);
        billIds.forEach(billId -> {
            StringBuilder url = new StringBuilder();
            String domainContextUrl = UrlService.getDomainContextUrl();
            url.append(domainContextUrl);
            url.append("?formId=bos_list");
            url.append("&type=list");
            url.append("&billFormId=");
            url.append("src_memberclarify");
            url.append("&basetype=");
            url.append(baseType);
            url.append("&pkId=");
            url.append(Long.parseLong(billId));
            String accountId = RequestContext.get().getAccountId();
            url.append("&accountId=");
            url.append(accountId);
            urlMaps.put((String)billId, url.toString());
        });
        return urlMaps;
    }
}

