/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.expertchange;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.src.common.expertchange.SrcExpertChangeUtils;

public class SrcExpertChangeDataDiff
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        DynamicObject oldObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillObj().getLong("expert.id"), (String)"src_expert");
        DynamicObject newObj = context.getBillObj();
        List<String> properties = SrcExpertChangeUtils.getObjectProperties(oldObj);
        Map proTypeMap = PdsMetadataUtil.getProTypeMap((String)context.getBillObj().getDataEntityType().getName(), (boolean)true);
        List<Map<String, Object>> changeList = SrcExpertChangeUtils.compareObjectDataDiff(context, oldObj, newObj, properties, proTypeMap);
        List<Map<String, Object>> entryChangeList = SrcExpertChangeUtils.compareEntryDataDiff(context, oldObj, newObj, Collections.emptyList(), proTypeMap);
        changeList.addAll(entryChangeList);
        DynamicObjectCollection rows = newObj.getDynamicObjectCollection("entrychange");
        rows.removeAll((Collection)rows);
        for (Map<String, Object> changeMap : changeList) {
            DynamicObject row = rows.addNew();
            row.set("changetype", (Object)PdsCommonUtils.object2String((Object)changeMap.get("changetype"), (String)"3"));
            row.set("fieldid", changeMap.get("fieldid"));
            row.set("fieldname", (Object)this.getFieldName(context, changeMap));
            row.set("oldvalue", changeMap.get("oldvalue"));
            row.set("newvalue", changeMap.get("newvalue"));
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject)newObj);
    }

    public String getFieldName(ExtPluginContext context, Map<String, Object> changeMap) {
        String fieldName = PdsCommonUtils.object2String((Object)changeMap.get("fieldname"), (String)"");
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            String fieldId = PdsCommonUtils.object2String((Object)changeMap.get("fieldid"), (String)"");
            String[] fieldIds = fieldId.split("\\|");
            if (fieldIds.length > 1) {
                fieldId = fieldIds[1];
            }
            Control control = context.getView().getControl(fieldId);
            fieldName = PdsMetadataUtil.getFieldDisplayName((Control)control);
        }
        StringBuilder title = new StringBuilder();
        if (null != changeMap.get("entityname")) {
            title.append(changeMap.get("entityname")).append("-->");
        }
        if (null != changeMap.get("index")) {
            title.append(ResManager.loadKDString((String)"\u7b2c", (String)"SrcExpertChangeDataDiff_0", (String)"scm-src-common", (Object[])new Object[0])).append(changeMap.get("index")).append(ResManager.loadKDString((String)"\u884c-->", (String)"SrcExpertChangeDataDiff_1", (String)"scm-src-common", (Object[])new Object[0]));
        }
        title.append(fieldName);
        return title.toString();
    }
}

