/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.expertchange;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.src.common.expertchange.SrcExpertChangeCreate;
import kd.scm.src.common.expertchange.SrcExpertChangeDataDiff;
import kd.scm.src.common.expertchange.SrcExpertChangeEntryCompare;
import kd.scm.src.common.expertchange.SrcExpertChangeExcludedFields;
import kd.scm.src.common.expertchange.SrcExpertChangeObjectCompare;
import kd.scm.src.common.expertchange.SrcExpertChangeValueCompare;

public class SrcExpertChangeUtils {
    public static void createOrOpenChangeBill(IFormView view, AfterDoOperationEventArgs args) {
        QFilter expertfilter;
        DynamicObject expertObj;
        QFilter qfilter = SrcExpertChangeUtils.getExpertFilterByCurrentUser(PdsCommonUtils.buildSet((String[])new String[]{BillStatusEnum.SAVE.getVal(), BillStatusEnum.SUBMIT.getVal()}));
        DynamicObject chgObj = QueryServiceHelper.queryOne((String)"src_myexpertchg", (String)"id,status", (QFilter[])qfilter.toArray());
        if (null == chgObj && null != (expertObj = QueryServiceHelper.queryOne((String)"src_expert", (String)"id", (QFilter[])(expertfilter = SrcExpertChangeUtils.getExpertFilterByCurrentUser(PdsCommonUtils.buildSet((String[])new String[]{BillStatusEnum.AUDIT.getVal()}))).toArray()))) {
            chgObj = SrcExpertChangeUtils.createChangeBill(expertObj.getLong("id"), args);
        }
        if (null == chgObj) {
            return;
        }
        long billId = chgObj.getLong("id");
        if (BillStatusEnum.SAVE.equals((Object)chgObj.getString("status"))) {
            OpenFormUtils.openBillPage((IFormView)view, (String)"src_myexpertchg", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
        } else {
            OpenFormUtils.openBillPage((IFormView)view, (String)"src_myexpertchg", (Object)billId, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
        }
    }

    public static DynamicObject createChangeBill(long expertId, AfterDoOperationEventArgs args) {
        ExtPluginContext context = new ExtPluginContext();
        context.setBillId(expertId);
        ExtPluginFactory.executeExtplugin((String)SrcExpertChangeCreate.class.getSimpleName(), (ExtPluginContext)context, (boolean)true, (String)SrcExpertChangeCreate.class.getName());
        return context.getBillObj();
    }

    public static void createChangeEntry(IFormView view, BeforeDoOperationEventArgs args) {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(view);
        context.setBeforeDoOperationEventArgs(args);
        List entryKeys = PdsMetadataUtil.getEntityKey_namesByControlType((String)"src_expert", (String)"entryap");
        context.setEntryKeys(entryKeys);
        context.setBillObj(view.getModel().getDataEntity(true));
        context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity()));
        DynamicObject expertObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillObj().getLong("expert.id"), (String)"src_expert");
        context.setProjectObj(expertObj);
        ExtPluginFactory.executeExtplugin((String)SrcExpertChangeDataDiff.class.getSimpleName(), (ExtPluginContext)context, (boolean)true, (String)SrcExpertChangeDataDiff.class.getName());
    }

    public static List<String> getObjectProperties(DynamicObject billObj) {
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)billObj);
        ExtPluginContext context = new ExtPluginContext();
        context.setBillObj(billObj);
        ExtPluginFactory.executeExtplugin((String)SrcExpertChangeExcludedFields.class.getSimpleName(), (ExtPluginContext)context, (boolean)true, (String)SrcExpertChangeExcludedFields.class.getName());
        if (null != context.getCompKeys() && context.getCompKeys().size() > 0) {
            properties.removeAll(context.getCompKeys().stream().collect(Collectors.toList()));
        }
        return properties;
    }

    public static List<String> getEntryProperties(DynamicObject row) {
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)row);
        properties.remove("id");
        properties.remove("fid");
        properties.remove("fseq");
        properties.remove("seq");
        return properties;
    }

    public static List<Map<String, Object>> compareObjectDataDiff(ExtPluginContext context, DynamicObject oldObj, DynamicObject newObj, List<String> properties, Map<String, String> proTypeMap) {
        context.setSourceObj(oldObj);
        context.setTargetObj(newObj);
        context.setBillProperties(properties);
        context.setResultMap(proTypeMap);
        ExtPluginFactory.executeExtplugin((String)SrcExpertChangeObjectCompare.class.getSimpleName(), (ExtPluginContext)context, (boolean)true, (String)SrcExpertChangeObjectCompare.class.getName());
        return context.getAttachList();
    }

    public static List<Map<String, Object>> compareEntryDataDiff(ExtPluginContext context, DynamicObject oldObj, DynamicObject newObj, List<String> properties, Map<String, String> proTypeMap) {
        context.setSourceObj(oldObj);
        context.setTargetObj(newObj);
        context.setBillProperties(properties);
        context.setResultMap(proTypeMap);
        ExtPluginFactory.executeExtplugin((String)SrcExpertChangeEntryCompare.class.getSimpleName(), (ExtPluginContext)context, (boolean)true, (String)SrcExpertChangeEntryCompare.class.getName());
        return context.getAttachList();
    }

    public static Map<String, Object> compareFieldValueDiff(ExtPluginContext context, String property) {
        context.setSourceType(property);
        ExtPluginFactory.executeExtplugin((String)SrcExpertChangeValueCompare.class.getSimpleName(), (ExtPluginContext)context, (boolean)true, (String)SrcExpertChangeValueCompare.class.getName());
        return (Map)context.getParamMap2().get("result");
    }

    public static QFilter getExpertFilterByCurrentUser(Set<String> statusSet) {
        QFilter qfilter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId());
        qfilter.and("status", "in", statusSet);
        return qfilter;
    }

    public static void autoAuditAfterSubmit(IFormView view, AfterDoOperationEventArgs args) {
        boolean isConfirm = view.getModel().getDataEntity().getBoolean("isconfirm");
        if (isConfirm) {
            return;
        }
        if (null != args.getOperationResult() && args.getOperationResult().isSuccess()) {
            PdsCommonUtils.doOperation((DynamicObject)view.getModel().getDataEntity(), (String)"audit");
        }
    }

    public static void deleteChangeBill(IFormView view, AfterDoOperationEventArgs args) {
        if (null != args.getOperationResult() && args.getOperationResult().isSuccess()) {
            QFilter qfilter = new QFilter("id", "in", (Object)args.getOperationResult().getSuccessPkIds());
            qfilter.and("status", "=", (Object)BillStatusEnum.SAVE.getVal());
            DeleteServiceHelper.delete((String)view.getEntityId(), (QFilter[])qfilter.toArray());
            PdsCommonUtils.refreshParentView((IFormView)view);
        }
    }
}

