/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.expertchange;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.DateUtil;
import kd.scm.pds.common.constant.FieldTypeConstant;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.ComboEditUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcExpertChangeValueCompare
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;
    Log log = LogFactory.getLog(SrcExpertChangeValueCompare.class);

    public void process(ExtPluginContext context) {
        this.compareFieldValueDiff(context);
    }

    public void compareFieldValueDiff(ExtPluginContext context) {
        context.getParamMap2().remove("result");
        Map proTypeMap = context.getResultMap();
        if (null == proTypeMap || proTypeMap.size() == 0) {
            return;
        }
        String property = context.getSourceType();
        String proType = (String)proTypeMap.get(property);
        if (StringUtils.isBlank((CharSequence)proType)) {
            return;
        }
        DynamicObject sourceObj = context.getSourceObj();
        DynamicObject targetObj = context.getTargetObj();
        HashMap<String, Object> changeMap = new HashMap<String, Object>(4);
        Object sourceValue = null;
        Object targetValue = null;
        try {
            sourceValue = null == sourceObj ? null : sourceObj.get(property);
            targetValue = null == targetObj ? null : targetObj.get(property);
        }
        catch (Exception e2) {
            this.log.info("###compareFieldValueDiff exception:" + e2.getMessage());
        }
        if (null == sourceValue && null == targetValue) {
            return;
        }
        if (FieldTypeConstant.getMulBasedataType().contains(proType) || FieldTypeConstant.getAttachType().contains(proType) || sourceValue instanceof DynamicObjectCollection || targetValue instanceof DynamicObjectCollection) {
            this.compareCollection(context, sourceValue, targetValue, property, proType, changeMap);
        } else if (FieldTypeConstant.getBasedataType().contains(proType) || sourceValue instanceof DynamicObject || targetValue instanceof DynamicObject) {
            this.compareBaseData(context, sourceValue, targetValue, property, proType, changeMap);
        } else if (FieldTypeConstant.getNumberType().contains(proType)) {
            this.compareNumber(context, sourceValue, targetValue, property, proType, changeMap);
        } else if (FieldTypeConstant.getDateType().contains(proType)) {
            this.compareDate(context, sourceValue, targetValue, property, proType, changeMap);
        } else if (FieldTypeConstant.getTextType().contains(proType)) {
            this.compareText(context, sourceValue, targetValue, property, proType, changeMap);
        } else {
            this.compareOther(context, sourceValue, targetValue, property, proType, changeMap);
        }
        if (null != changeMap && changeMap.size() > 0) {
            context.getParamMap2().put("result", changeMap);
        }
    }

    public void compareCollection(ExtPluginContext context, Object sourceValue, Object targetValue, String property, String proType, Map<String, Object> changeMap) {
        if (null == sourceValue) {
            DynamicObjectCollection targetRows = PdsCommonUtils.object2DynamicObjectCollection((Object)targetValue);
            if (null != targetRows && targetRows.size() > 0) {
                changeMap.put("fieldid", property);
                changeMap.put("oldvalue", null);
                changeMap.put("newvalue", PdsCommonUtils.getMultiBaseDataName((DynamicObjectCollection)targetRows));
            }
        } else if (null == targetValue) {
            DynamicObjectCollection sourceRows = PdsCommonUtils.object2DynamicObjectCollection((Object)sourceValue);
            if (null != sourceRows && sourceRows.size() > 0) {
                changeMap.put("fieldid", property);
                changeMap.put("oldvalue", PdsCommonUtils.getMultiBaseDataName((DynamicObjectCollection)sourceRows));
                changeMap.put("newvalue", null);
            }
        } else {
            DynamicObjectCollection sourceRows = PdsCommonUtils.object2DynamicObjectCollection((Object)sourceValue);
            DynamicObjectCollection targetRows = PdsCommonUtils.object2DynamicObjectCollection((Object)targetValue);
            if (null != sourceRows && null != targetRows && (sourceRows.size() > 0 || targetRows.size() > 0)) {
                if (sourceRows.size() != targetRows.size()) {
                    changeMap.put("fieldid", property);
                    changeMap.put("oldvalue", String.format(ResManager.loadKDString((String)"\u8bb0\u5f55\u6570\uff1a%1$s, \u5185\u5bb9\uff1a%2$s", (String)"SrcExpertChangeValueCompare_0", (String)"scm-src-common", (Object[])new Object[0]), sourceRows.size(), PdsCommonUtils.getMultiBaseDataName((DynamicObjectCollection)sourceRows)));
                    changeMap.put("newvalue", String.format(ResManager.loadKDString((String)"\u8bb0\u5f55\u6570\uff1a%1$s, \u5185\u5bb9\uff1a%2$s", (String)"SrcExpertChangeValueCompare_0", (String)"scm-src-common", (Object[])new Object[0]), targetRows.size(), PdsCommonUtils.getMultiBaseDataName((DynamicObjectCollection)targetRows)));
                } else {
                    Set sourceSet = PdsCommonUtils.getMultiBaseDataIdSet((DynamicObjectCollection)sourceRows);
                    Set targetSet = PdsCommonUtils.getMultiBaseDataIdSet((DynamicObjectCollection)targetRows);
                    if (null != sourceSet && null != targetSet && PdsCommonUtils.getIntersectSet((Set)sourceSet, (Set)targetSet).size() != sourceSet.size()) {
                        changeMap.put("fieldid", property);
                        changeMap.put("oldvalue", PdsCommonUtils.getMultiBaseDataName((DynamicObjectCollection)sourceRows));
                        changeMap.put("newvalue", PdsCommonUtils.getMultiBaseDataName((DynamicObjectCollection)targetRows));
                    }
                }
            }
        }
    }

    public void compareBaseData(ExtPluginContext context, Object sourceValue, Object targetValue, String property, String proType, Map<String, Object> changeMap) {
        if (null == sourceValue) {
            DynamicObject targetDyn = PdsCommonUtils.object2DynamicObject((Object)targetValue);
            if (null != targetDyn) {
                changeMap.put("fieldid", property);
                changeMap.put("oldvalue", null);
                changeMap.put("newvalue", PdsCommonUtils.getBaseDataName((DynamicObject)targetDyn));
            }
        } else if (null == targetValue) {
            DynamicObject sourceDyn = PdsCommonUtils.object2DynamicObject((Object)sourceValue);
            if (null != sourceDyn) {
                changeMap.put("fieldid", property);
                changeMap.put("oldvalue", PdsCommonUtils.getBaseDataName((DynamicObject)sourceDyn));
                changeMap.put("newvalue", null);
            }
        } else {
            DynamicObject sourceDyn = PdsCommonUtils.object2DynamicObject((Object)sourceValue);
            DynamicObject targetDyn = PdsCommonUtils.object2DynamicObject((Object)targetValue);
            if (null != sourceDyn && null != targetDyn && sourceDyn.getLong("id") != targetDyn.getLong("id")) {
                changeMap.put("fieldid", property);
                changeMap.put("oldvalue", PdsCommonUtils.getBaseDataName((DynamicObject)sourceDyn));
                changeMap.put("newvalue", PdsCommonUtils.getBaseDataName((DynamicObject)targetDyn));
            }
        }
    }

    public void compareNumber(ExtPluginContext context, Object sourceValue, Object targetValue, String property, String proType, Map<String, Object> changeMap) {
        if (sourceValue instanceof Integer || targetValue instanceof Integer) {
            int targetNum;
            int sourceNum = PdsCommonUtils.object2Integer((Object)sourceValue);
            if (sourceNum != (targetNum = PdsCommonUtils.object2Integer((Object)targetValue))) {
                changeMap.put("fieldid", property);
                changeMap.put("oldvalue", sourceNum);
                changeMap.put("newvalue", targetNum);
            }
        } else if (sourceValue instanceof Long || targetValue instanceof Long) {
            long targetNum;
            long sourceNum = PdsCommonUtils.object2Long((Object)sourceValue);
            if (sourceNum != (targetNum = PdsCommonUtils.object2Long((Object)targetValue))) {
                changeMap.put("fieldid", property);
                changeMap.put("oldvalue", sourceNum);
                changeMap.put("newvalue", targetNum);
            }
        } else {
            BigDecimal targetNum;
            BigDecimal sourceNum = PdsCommonUtils.object2BigDecimal((Object)sourceValue);
            if (sourceNum.compareTo(targetNum = PdsCommonUtils.object2BigDecimal((Object)targetValue)) != 0) {
                changeMap.put("fieldid", property);
                changeMap.put("oldvalue", sourceNum.setScale(4));
                changeMap.put("newvalue", targetNum.setScale(4));
            }
        }
    }

    public void compareDate(ExtPluginContext context, Object sourceValue, Object targetValue, String property, String proType, Map<String, Object> changeMap) {
        String formatParten = null;
        formatParten = "DateEdit".equals(proType) ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss";
        if (null == sourceValue) {
            Date targetDate = PdsCommonUtils.object2Date((Object)targetValue);
            changeMap.put("fieldid", property);
            changeMap.put("oldvalue", null);
            changeMap.put("newvalue", DateUtil.date2str((Date)targetDate, (String)formatParten));
        } else if (null == targetValue) {
            Date sourceDate = PdsCommonUtils.object2Date((Object)sourceValue);
            changeMap.put("fieldid", property);
            changeMap.put("oldvalue", DateUtil.date2str((Date)sourceDate, (String)formatParten));
            changeMap.put("newvalue", null);
        } else {
            Date targetDate;
            Date sourceDate = PdsCommonUtils.object2Date((Object)sourceValue);
            if (sourceDate.compareTo(targetDate = PdsCommonUtils.object2Date((Object)targetValue)) != 0) {
                changeMap.put("fieldid", property);
                changeMap.put("oldvalue", DateUtil.date2str((Date)sourceDate, (String)formatParten));
                changeMap.put("newvalue", DateUtil.date2str((Date)targetDate, (String)formatParten));
            }
        }
    }

    public void compareText(ExtPluginContext context, Object sourceValue, Object targetValue, String property, String proType, Map<String, Object> changeMap) {
        String targetStr;
        String sourceStr = PdsCommonUtils.object2String((Object)sourceValue, (String)"");
        if (!StringUtils.equals((CharSequence)sourceStr, (CharSequence)(targetStr = PdsCommonUtils.object2String((Object)targetValue, (String)"")))) {
            changeMap.put("fieldid", property);
            if ("ComboEdit".equals(proType) || "MulComboEdit".equals(proType) || "BillStatusEdit".equals(proType)) {
                if (!StringUtils.isBlank((CharSequence)sourceStr)) {
                    sourceStr = ComboEditUtils.getComboKeyByValue((DynamicObject)context.getBillObj(), (String)property, (String)sourceStr);
                }
                if (!StringUtils.isBlank((CharSequence)targetStr)) {
                    targetStr = ComboEditUtils.getComboKeyByValue((DynamicObject)context.getBillObj(), (String)property, (String)targetStr);
                }
            } else if ("FieldEdit".equals(proType)) {
                if (!StringUtils.isBlank((CharSequence)sourceStr)) {
                    String string = sourceStr = PdsCommonUtils.object2Boolean((Object)sourceValue) ? ResManager.loadKDString((String)"\u662f", (String)"SrcExpertChangeValueCompare_1", (String)"scm-src-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"SrcExpertChangeValueCompare_2", (String)"scm-src-common", (Object[])new Object[0]);
                }
                if (!StringUtils.isBlank((CharSequence)targetStr)) {
                    targetStr = PdsCommonUtils.object2Boolean((Object)targetValue) ? ResManager.loadKDString((String)"\u662f", (String)"SrcExpertChangeValueCompare_1", (String)"scm-src-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"SrcExpertChangeValueCompare_2", (String)"scm-src-common", (Object[])new Object[0]);
                }
            }
            changeMap.put("oldvalue", sourceStr);
            changeMap.put("newvalue", targetStr);
        }
    }

    public void compareOther(ExtPluginContext context, Object sourceValue, Object targetValue, String property, String proType, Map<String, Object> changeMap) {
        String targetStr;
        String sourceStr = PdsCommonUtils.object2String((Object)sourceValue, (String)"");
        if (!StringUtils.equals((CharSequence)sourceStr, (CharSequence)(targetStr = PdsCommonUtils.object2String((Object)targetValue, (String)"")))) {
            changeMap.put("fieldid", property);
            changeMap.put("oldvalue", sourceStr);
            changeMap.put("newvalue", targetStr);
        }
    }
}

