/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.extplugin.dataupgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcDataUpgradePreviousTurnsPrice
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;
    private int count = 100;

    public void process(ExtPluginContext context) {
        Set<Long> allProjectIds = this.getAllProjectIds(context);
        if (null == allProjectIds || allProjectIds.size() == 0) {
            context.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u5bfb\u6e90\u9879\u76ee\u3002", (String)"SrcDataUpgradePreviousTurnsPrice_2", (String)"scm-src-common", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> projectIds = new HashSet<Long>(this.count);
        Iterator<Long> ite = allProjectIds.iterator();
        while (ite.hasNext()) {
            projectIds.add(ite.next());
            if (projectIds.size() < this.count) continue;
            this.updatePreTurnsPrice(context, projectIds);
            projectIds = new HashSet();
        }
        if (projectIds.size() > 0) {
            this.updatePreTurnsPrice(context, projectIds);
        }
        context.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f\uff0c\u5171\u5904\u7406\u5bfb\u6e90\u9879\u76ee\uff1a%1$s", (String)"SrcDataUpgradePreviousTurnsPrice_3", (String)"scm-src-common", (Object[])new Object[0]), allProjectIds.size()));
    }

    public void updatePreTurnsPrice(ExtPluginContext context, Set<Long> projectSet) {
        Map<String, List<DynamicObject>> purlistMap = this.getPurlistMap(projectSet);
        if (null == purlistMap || purlistMap.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> purlistObjs = new ArrayList<DynamicObject>();
        for (Map.Entry<String, List<DynamicObject>> entry : purlistMap.entrySet()) {
            DynamicObject firstPurlistObj = entry.getValue().get(0);
            if (entry.getValue().size() == 1) {
                DynamicObject curPurlistObj = entry.getValue().get(0);
                this.updateFirstTurnsValue(curPurlistObj, firstPurlistObj);
                purlistObjs.add(curPurlistObj);
                continue;
            }
            for (int i = 1; i < entry.getValue().size(); ++i) {
                DynamicObject prePurlistObj = entry.getValue().get(i - 1);
                DynamicObject curPurlistObj = entry.getValue().get(i);
                this.updateFirstTurnsValue(curPurlistObj, firstPurlistObj);
                this.updatePreviousTurnsValue(curPurlistObj, prePurlistObj);
                purlistObjs.add(curPurlistObj);
            }
        }
        PdsCommonUtils.saveDynamicObjects(purlistObjs);
    }

    public void updateFirstTurnsValue(DynamicObject curPurlistObj, DynamicObject firstPurlistObj) {
        if (curPurlistObj.getBigDecimal("firstprice").compareTo(BigDecimal.ZERO) == 0) {
            curPurlistObj.set("firstprice", firstPurlistObj.get("price"));
        }
        if (curPurlistObj.getBigDecimal("firsttaxprice").compareTo(BigDecimal.ZERO) == 0) {
            curPurlistObj.set("firsttaxprice", firstPurlistObj.get("taxprice"));
        }
        if (curPurlistObj.getBigDecimal("firstamount").compareTo(BigDecimal.ZERO) == 0) {
            curPurlistObj.set("firstamount", firstPurlistObj.get("amount"));
        }
        if (curPurlistObj.getBigDecimal("firsttaxamount").compareTo(BigDecimal.ZERO) == 0) {
            curPurlistObj.set("firsttaxamount", firstPurlistObj.get("taxamount"));
        }
    }

    public void updatePreviousTurnsValue(DynamicObject curPurlistObj, DynamicObject prePurlistObj) {
        curPurlistObj.set("historyprice", prePurlistObj.get("price"));
        curPurlistObj.set("historytaxprice", prePurlistObj.get("taxprice"));
        curPurlistObj.set("preamount", prePurlistObj.get("amount"));
        curPurlistObj.set("pretaxamount", prePurlistObj.get("taxamount"));
    }

    public Map<String, List<DynamicObject>> getPurlistMap(Set<Long> projectSet) {
        QFilter qFilter = new QFilter("project", "in", projectSet);
        qFilter.and("supplier", ">", (Object)0L);
        String selectFields = "project,package,purlist,supplier,turns,price,taxprice,amount,taxamount,historyprice,historytaxprice,preamount,pretaxamount,firstprice,firsttaxprice,firstamount,firsttaxamount";
        String orderBy = "project,package,purlist,supplier,turns";
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qFilter.toArray(), (String)orderBy);
        if (null == rows || rows.length == 0) {
            return null;
        }
        return Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getString("project.id") + '_' + e.getString("package.id") + '_' + e.getString("purlist.id") + '_' + e.getString("supplier.id")));
    }

    public Set<Long> getAllProjectIds(ExtPluginContext context) {
        QFilter projectFilter = this.getProjectFilter(context);
        HashSet<Long> projectIds = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)SrcDataUpgradePreviousTurnsPrice.class.getSimpleName(), (String)"src_purlistf7", (String)"project.id", (QFilter[])projectFilter.toArray(), (String)"project.id");){
            dataSet.forEach(row -> projectIds.add(row.getLong("project.id")));
        }
        return projectIds;
    }

    public QFilter getProjectFilter(ExtPluginContext context) {
        QFilter qFilter = new QFilter("project", ">", (Object)0);
        QFilter dateFilter = ExtFilterUtils.getDateScopeFilter((DynamicObject)context.getView().getModel().getDataEntity(), (String)"datefrom", (String)"dateto", (String)"project.createtime");
        if (null != dateFilter) {
            qFilter.and(dateFilter);
        }
        qFilter.and("project.billstatus", ">=", (Object)"C");
        qFilter.and("entrystatus", ">=", (Object)"C");
        qFilter.and("supplier", ">", (Object)0);
        QFilter preFilter = new QFilter("historyprice", "=", (Object)BigDecimal.ZERO);
        preFilter.and("historytaxprice", "=", (Object)BigDecimal.ZERO);
        preFilter.and("preamount", "=", (Object)BigDecimal.ZERO);
        preFilter.and("pretaxamount", "=", (Object)BigDecimal.ZERO);
        preFilter.and("turns", ">", (Object)"1");
        QFilter firstFilter = new QFilter("firstprice", "=", (Object)BigDecimal.ZERO);
        firstFilter.and("firsttaxprice", "=", (Object)BigDecimal.ZERO);
        firstFilter.and("firstamount", "=", (Object)BigDecimal.ZERO);
        firstFilter.and("firsttaxamount", "=", (Object)BigDecimal.ZERO);
        firstFilter.and("turns", "=", (Object)"1");
        qFilter.and(preFilter.or(firstFilter));
        return qFilter;
    }
}

