/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.extplugin.purlist;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcPurlistWriteBackSrcEntryPlugin
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        DynamicObject[] objs;
        DynamicObject purListObj = context.getBillObj();
        DynamicObjectCollection cols = purListObj.getDynamicObjectCollection("entryentity");
        if (cols.size() == 0) {
            return;
        }
        List<String> isEditableProList = this.getEditableProList(context);
        if (isEditableProList.size() == 0) {
            return;
        }
        this.setOrderRatio(cols);
        Map<Long, DynamicObject> entryIdColMap = this.getColMap(cols);
        for (DynamicObject obj : objs = this.getSrcPurlistData(entryIdColMap.keySet(), isEditableProList)) {
            DynamicObject col = entryIdColMap.get(PdsCommonUtils.object2Long((Object)obj.getPkValue()));
            if (null == col) continue;
            for (String pro : isEditableProList) {
                Object proVal = col.get(pro);
                this.setVal(obj, pro, proVal);
            }
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    public void setVal(DynamicObject obj, String pro, Object proVal) {
        DynamicProperty property = obj.getDynamicObjectType().getProperty(pro);
        if (null == property) {
            return;
        }
        if (proVal instanceof DynamicObjectCollection) {
            obj.set(pro, (Object)PdsCommonUtils.cloneCols((DynamicObjectCollection)((DynamicObjectCollection)proVal)));
        } else if (proVal instanceof DynamicObject) {
            obj.set(pro, ((DynamicObject)proVal).getPkValue());
        } else {
            obj.set(pro, proVal);
        }
    }

    public DynamicObject[] getSrcPurlistData(Set<Long> srcEntryIdSet, List<String> isEditableProList) {
        QFilter entryIdFilter = new QFilter("entryid", "in", srcEntryIdSet);
        String selectFields = this.getSelectFields(isEditableProList);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])new QFilter[]{entryIdFilter});
        return objs;
    }

    public Map<Long, DynamicObject> getColMap(DynamicObjectCollection cols) {
        Map<Long, DynamicObject> entryIdColMap = cols.stream().collect(Collectors.toMap(col -> col.getLong("srcentryid"), col -> col, (v1, v2) -> v1));
        return entryIdColMap;
    }

    public void setOrderRatio(DynamicObjectCollection cols) {
        SrcPurListUtil.validatorMaterialNaneSupplier(cols);
    }

    public List<String> getEditableProList(ExtPluginContext context) {
        List<String> isEditableProList = new ArrayList<String>();
        IFormView compView = context.getView();
        Object compConfigId = compView.getModel().getValue("compconfigid");
        if (null == compConfigId || String.valueOf(compConfigId).trim().length() == 0) {
            return isEditableProList;
        }
        DynamicObject compConfigObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(compConfigId.toString()), (String)"pds_compconfig");
        isEditableProList = PdsCompConfigUtil.getProsByCompConfig((DynamicObject)compConfigObj, (String)compView.getEntityId(), (String)"entryentity", (String)"iseditable", (boolean)true);
        ArrayList<String> calPros = new ArrayList<String>(8);
        calPros.add("qty");
        calPros.add("price");
        calPros.add("taxprice");
        calPros.add("amount");
        calPros.add("taxamount");
        calPros.add("tax");
        calPros.add("dctamount");
        if (isEditableProList.contains("taxprice") || isEditableProList.contains("price") || isEditableProList.contains("amount") || isEditableProList.contains("taxamount") || isEditableProList.contains("qty")) {
            for (String calPro : calPros) {
                if (isEditableProList.contains(calPro)) continue;
                isEditableProList.add(calPro);
            }
        }
        return isEditableProList;
    }

    public String getSelectFields(List<String> isEditableProList) {
        StringBuilder selectFieldsSb = new StringBuilder("id");
        for (String pro : isEditableProList) {
            if (selectFieldsSb.length() > 0) {
                selectFieldsSb.append(",").append(pro);
                continue;
            }
            selectFieldsSb.append(pro);
        }
        return selectFieldsSb.toString();
    }
}

