/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.extplugin.srcoreassist;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreFacade;

public class SrcScoreInitSupplierOrder
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        long projectId = PdsCommonUtils.object2Long(context.getParamMap().get("projectid"));
        long sourceFlowId = PdsCommonUtils.object2Long(context.getParamMap().get("sourceflow"));
        boolean isHideSupplier = PdsCommonUtils.object2Boolean(context.getParamMap().get("ishidesupplier"));
        boolean isEvaluateScore = SrcScoreFacade.isEvaluateScore(context.getView().getEntityId());
        boolean isSimpleName = false;
        if (!isHideSupplier && !isEvaluateScore) {
            isSimpleName = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isScoreBySupSimpleName", (Object)false, (long)projectId));
        }
        String orderType = "1";
        if (!isEvaluateScore) {
            PdsCommonUtils.object2String((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isScoreBySupOrderType", (Object)"1", (long)projectId), (String)"1");
        }
        Map supMap = new HashMap(32);
        Object supObject = context.getParamMap().get("supplier");
        if (supObject instanceof Map) {
            supMap = (Map)supObject;
        }
        Set<Long> supplierIds = supMap.keySet().stream().map(e -> Long.parseLong(e)).collect(Collectors.toSet());
        Map<Object, Object> supplierMap = new HashMap();
        if ("7".equals(orderType)) {
            supplierMap = this.getAssessOrderMap(supplierIds, projectId);
        } else if (isSimpleName) {
            supplierMap = this.getSimpleNameMap(supplierIds);
        }
        List<String> supplierList = this.getSortedSupplierIds(context, orderType, supplierIds, projectId);
        LinkedHashMap<String, String> sortedSupMap = new LinkedHashMap<String, String>(supMap.size());
        for (String supplierId : supplierList) {
            String newName = (String)supMap.get(supplierId);
            DynamicObject obj = (DynamicObject)supplierMap.get(supplierId);
            if (null != obj) {
                if ("7".equals(orderType)) {
                    newName = obj.getString("assessorder");
                } else if (isSimpleName) {
                    newName = obj.getString("simplename");
                }
            }
            if (StringUtils.isBlank((CharSequence)newName)) {
                newName = (String)supMap.get(supplierId);
            }
            sortedSupMap.put(supplierId, newName);
        }
        context.getParamMap().put("supplier", sortedSupMap);
    }

    public List<String> getSortedSupplierIds(ExtPluginContext context, String orderType, Set<Long> supplierIds, long projectId) {
        DynamicObjectCollection rows = null;
        String orderBy = this.getOrderByStr(orderType);
        switch (orderType) {
            case "5": {
                QFilter tndFilter = new QFilter("project", "=", (Object)projectId).and("supplier", "in", supplierIds);
                rows = QueryServiceHelper.query((String)"tnd_tenderbill", (String)"supplier.id,billdate", (QFilter[])tndFilter.toArray(), (String)orderBy);
                return rows.stream().distinct().map(e -> e.getString("supplier.id")).collect(Collectors.toList());
            }
            case "6": 
            case "7": {
                QFilter tenderFilter = new QFilter("billid", "=", (Object)projectId).and("supplier", "in", supplierIds);
                rows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"supplier.id,assessorder", (QFilter[])tenderFilter.toArray(), (String)orderBy);
                return rows.stream().distinct().map(e -> e.getString("supplier.id")).collect(Collectors.toList());
            }
        }
        QFilter supFilter = new QFilter("id", "in", supplierIds);
        rows = SrcScoreFacade.isEvaluateScore(context.getView().getEntityId()) ? QueryServiceHelper.query((String)"src_expert", (String)"id,number,name", (QFilter[])supFilter.toArray(), (String)orderBy) : QueryServiceHelper.query((String)"bd_supplier", (String)"id,number,name,simplename,simplepinyin", (QFilter[])supFilter.toArray(), (String)orderBy);
        return rows.stream().map(e -> e.getString("id")).collect(Collectors.toList());
    }

    public Map<String, DynamicObject> getSimpleNameMap(Set<Long> supplierIds) {
        QFilter supFilter = new QFilter("id", "in", supplierIds);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"bd_supplier", (String)"id,number,name,simplename,simplepinyin", (QFilter[])supFilter.toArray());
        return rows.stream().collect(Collectors.groupingBy(e -> e.getString("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    public Map<String, DynamicObject> getAssessOrderMap(Set<Long> supplierIds, long projectId) {
        QFilter tenderFilter = new QFilter("billid", "=", (Object)projectId);
        tenderFilter.and("supplier", "in", supplierIds);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"supplier.id,assessorder", (QFilter[])tenderFilter.toArray());
        return rows.stream().collect(Collectors.groupingBy(e -> e.getString("supplier.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    public String getOrderByStr(String orderType) {
        String orderBy = "number";
        switch (orderType) {
            case "1": {
                orderBy = "number";
                break;
            }
            case "2": {
                orderBy = "name";
                break;
            }
            case "3": {
                orderBy = "simplename,number";
                break;
            }
            case "4": {
                orderBy = "simplepinyin,number";
                break;
            }
            case "5": {
                orderBy = "billdate";
                break;
            }
            case "6": 
            case "7": {
                orderBy = "assessorder";
                break;
            }
        }
        return orderBy;
    }
}

