/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.hyperlink;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsDefaultConfigUtil;
import kd.scm.pds.common.util.PdsParameterUtils;
import kd.scm.pds.common.util.SrcDateUtils;

public class SrcPurListHyperlinkHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        switch (context.getHyperLinkClickEvent().getFieldName()) {
            case "price12": 
            case "price13": 
            case "price14": 
            case "price15": 
            case "bestprice": 
            case "usdprice": {
                this.hyperlinkHandle(context.getView(), context.getHyperLinkClickEvent());
                break;
            }
        }
    }

    protected void hyperlinkHandle(IFormView view, HyperLinkClickEvent evt) {
        Map<String, Object> paramMap = this.getParamMap(view, evt);
        if (null == paramMap || paramMap.size() == 0) {
            return;
        }
        switch (evt.getFieldName()) {
            case "price12": {
                this.setParamMapForLastPrice(paramMap, "locprice");
                break;
            }
            case "price13": {
                this.setParamMapForLastPrice(paramMap, "loctaxprice");
                break;
            }
            case "price14": {
                this.setParamMapForHistoryPrice(paramMap, "locprice");
                break;
            }
            case "price15": {
                this.setParamMapForHistoryPrice(paramMap, "loctaxprice");
                break;
            }
            case "bestprice": {
                this.setParamMapForProjectPrice(paramMap, "locprice");
                break;
            }
            case "usdprice": {
                this.setParamMapForProjectPrice(paramMap, "loctaxprice");
                break;
            }
            default: {
                return;
            }
        }
        QFilter qfilters = QFilter.fromSerializedString((String)paramMap.get("qfilter").toString());
        OpenFormUtils.openListPage((IFormView)view, (String)"src_analysetool", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)qfilters, null);
    }

    protected void setParamMapForLastPrice(Map<String, Object> paramMap, String fieldName) {
        QFilter qfilters = this.getHistoryQFilter(paramMap);
        paramMap.put("qfilter", qfilters.toSerializedString());
        paramMap.put("orderby", "project.createtime desc," + fieldName);
    }

    protected void setParamMapForHistoryPrice(Map<String, Object> paramMap, String fieldName) {
        QFilter qfilters = this.getHistoryQFilter(paramMap);
        paramMap.put("qfilter", qfilters.toSerializedString());
        paramMap.put("orderby", fieldName + ',' + "quotedate");
    }

    protected void setParamMapForProjectPrice(Map<String, Object> paramMap, String fieldName) {
        QFilter qfilters = new QFilter("project", "=", (Object)PdsCommonUtils.object2Long((Object)paramMap.get("projectid")));
        qfilters.and("purlist", "=", (Object)PdsCommonUtils.object2Long((Object)paramMap.get("purlistid")));
        qfilters.and("entrystatus", "in", Arrays.asList("C", "D"));
        qfilters.and(new QFilter("locprice", ">", (Object)BigDecimal.ZERO).or("loctaxprice", ">", (Object)BigDecimal.ZERO));
        paramMap.put("qfilter", qfilters.toSerializedString());
        paramMap.put("orderby", fieldName + ',' + "quotedate");
    }

    protected QFilter getHistoryQFilter(Map<String, Object> paramMap) {
        long projectId = PdsCommonUtils.object2Long((Object)paramMap.get("projectid"));
        int monthnum = 0;
        long currencyId = 0L;
        if (projectId > 0L) {
            QFilter projectFilter = new QFilter("id", "=", (Object)projectId);
            DynamicObject baseObj = QueryServiceHelper.queryOne((String)"src_project_base", (String)"currency.id, monthnum", (QFilter[])projectFilter.toArray());
            currencyId = baseObj.getLong("currency.id");
            monthnum = baseObj.getInt("monthnum");
            if (monthnum == 0) {
                monthnum = Integer.parseInt(PdsDefaultConfigUtil.getDefaultValue((DynamicObject)baseObj, (String)"src_project", (String)"src_project_base", (String)"monthnum", (Object)12).toString());
            }
        } else {
            currencyId = PdsCommonUtils.object2Long((Object)paramMap.get("currencyid"));
            monthnum = 24;
        }
        Date historyDate = SrcDateUtils.getDateByOffsetDay((Date)TimeServiceHelper.now(), (int)(-monthnum * 30));
        QFilter qfilters = new QFilter("material", "=", (Object)PdsCommonUtils.object2Long((Object)paramMap.get("materialid")));
        qfilters.and("project.openstatus", "=", (Object)"9");
        Set resultValueSet = PdsParameterUtils.getResultValueSet();
        qfilters.and("result", "in", (Object)resultValueSet);
        qfilters.and(new QFilter("locprice", ">", (Object)BigDecimal.ZERO).or("loctaxprice", ">", (Object)BigDecimal.ZERO));
        qfilters.and("loccurr", "=", (Object)currencyId);
        qfilters.and("project.createtime", ">=", (Object)historyDate);
        return qfilters;
    }

    protected Map<String, Object> getParamMap(IFormView view, HyperLinkClickEvent evt) {
        IFormView pView = view.getParentView();
        if (pView.getEntityId().substring(0, 3).equals("tnd")) {
            return null;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DynamicObject row = view.getModel().getEntryRowEntity("entryentity", evt.getRowIndex());
        long projectId = 0L;
        long purlistId = 0L;
        long materialId = 0L;
        if ("src_apply".equals(view.getEntityId())) {
            materialId = row.getLong("material.id");
            paramMap.put("currencyid", view.getModel().getDataEntity().getLong("currency.id"));
        } else if ("src_demand".equals(view.getEntityId()) || "src_demand_comp".equals(view.getEntityId())) {
            materialId = row.getLong("material1.id");
            paramMap.put("currencyid", view.getModel().getDataEntity().getLong("currency.id"));
        } else {
            projectId = row.getLong("project.id");
            purlistId = row.getLong("purlist.id");
            materialId = row.getLong("material.id");
        }
        paramMap.put("projectid", projectId);
        paramMap.put("purlistid", purlistId);
        paramMap.put("materialid", materialId);
        return paramMap;
    }
}

