/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.negopen;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.SrcNegotiatetypeEnums;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.src.common.negopen.ISrcNegAuditHandler;
import kd.scm.src.common.negopen.ISrcNegOpenHandler;
import kd.scm.src.common.negopen.ISrcNegOpenPrepare;
import kd.scm.src.common.negopen.ISrcNegOpenValidator;
import kd.scm.src.common.negopen.ISrcNegUnAuditHandler;
import kd.scm.src.common.negopen.SrcNegOpenContext;
import kd.scm.src.common.negopen.SrcNegOpenFactory;
import kd.scm.src.common.util.SrcNegotiateUtil;
import org.apache.commons.lang.StringUtils;

public class SrcNegOpenFacade {
    public static SrcNegOpenContext createContext(DynamicObject billObj) {
        SrcNegOpenContext context = new SrcNegOpenContext();
        DynamicObject negBillObj = BusinessDataServiceHelper.loadSingle((Object)billObj.getPkValue(), (String)"src_negotiatebill");
        context.setNegBillObj(negBillObj);
        DynamicObject projectObj = context.getNegBillObj().getDynamicObject("project");
        context.setProjectObj(projectObj);
        context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        String turns = context.getNegBillObj().getString("turns");
        context.setTurns(turns);
        String negotiateType = context.getNegBillObj().getString("negotiatetype");
        context.setNegotiateType(negotiateType);
        if (StringUtils.equals((String)SrcNegotiatetypeEnums.OFFLINE_PURLIST.getValue(), (String)negotiateType) || StringUtils.equals((String)SrcNegotiatetypeEnums.OFFLINE_PACKAGE.getValue(), (String)negotiateType)) {
            context.setOffline(true);
        }
        return context;
    }

    public static void negOpenHandle(DynamicObject negBillObj) {
        SrcNegOpenContext context = SrcNegOpenFacade.createContext(negBillObj);
        SrcNegOpenFacade.negOpenPrepare(context);
        SrcNegOpenFacade.negOpenHandle(context);
    }

    private static void negOpenPrepare(SrcNegOpenContext context) {
        List<ISrcNegOpenPrepare> handlers = SrcNegOpenFactory.getNegOpenPrepareInstances();
        for (ISrcNegOpenPrepare handler : handlers) {
            handler.process(context);
        }
    }

    private static void negOpenHandle(SrcNegOpenContext context) {
        List<ISrcNegOpenHandler> handlers = SrcNegOpenFactory.getNegOpenHandlerInstances();
        for (ISrcNegOpenHandler handler : handlers) {
            handler.process(context);
        }
    }

    public static void updateNegBizStatus(DynamicObject billObj) {
        billObj.set("bizstatus", (Object)BillStatusEnum.AUDIT.getVal());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
    }

    public static String negAutoOpenVerify(DynamicObject billObj) {
        List validators = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ISrcNegOpenValidator.class.getSimpleName(), null);
        if (null == validators || validators.size() == 0) {
            return "succed";
        }
        SrcValidatorData context = new SrcValidatorData();
        context.setBillObj(billObj);
        context.setSucced(true);
        for (ISrcValidator validator : validators) {
            validator.validate(context);
        }
        if (context.isSucced()) {
            return "succed";
        }
        return context.getMessage();
    }

    public static void negAuditHandle(DynamicObject negBillObj) {
        SrcNegOpenContext context = SrcNegOpenFacade.createContext(negBillObj);
        SrcNegOpenFacade.getNegBillInfo(context);
        List<ISrcNegAuditHandler> handlers = SrcNegOpenFactory.getNegAuditHandlerInstances();
        for (ISrcNegAuditHandler handler : handlers) {
            handler.process(context);
        }
        SrcNegOpenFacade.updateNegBizStatus(context.getNegBillObj());
    }

    public static void negDetailsHandle(DynamicObject negBillObj) {
        SrcNegOpenContext context = SrcNegOpenFacade.createContext(negBillObj);
        SrcNegOpenFacade.getNegBillInfo(context);
        if (context.isOffline()) {
            SrcNegotiateUtil.createNegDetails(context);
        }
    }

    public static void negUnAuditHandle(DynamicObject negBillObj) {
        SrcNegOpenContext context = SrcNegOpenFacade.createContext(negBillObj);
        List<ISrcNegUnAuditHandler> handlers = SrcNegOpenFactory.getNegUnAuditHandlerInstances();
        for (ISrcNegUnAuditHandler handler : handlers) {
            handler.process(context);
        }
    }

    public static void getNegBillInfo(SrcNegOpenContext context) {
        List<ISrcNegOpenPrepare> handlers = SrcNegOpenFactory.getNegBillInfoPrepareInstances();
        for (ISrcNegOpenPrepare handler : handlers) {
            handler.process(context);
        }
    }

    public static SrcNegOpenContext getNegOpenTipMessage(DynamicObject negBillObj) {
        SrcNegOpenContext context = SrcNegOpenFacade.createContext(negBillObj);
        List<ISrcNegOpenPrepare> handlers = SrcNegOpenFactory.getNegOpenTipMessagePrepareInstances();
        for (ISrcNegOpenPrepare handler : handlers) {
            handler.process(context);
        }
        return context;
    }
}

