/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.patternfilter;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extfilter.ExtFilterContext;
import kd.scm.pds.common.extfilter.ExtFilterFactory;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extfilter.FilterGridUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.patternfilter.IPatternFilter;
import kd.scm.src.common.patternfilter.PatternFilterContext;

public class PatternFilterUtils {
    public static QFilter getSchemeFilter(IFormView view) {
        PatternFilterContext context = new PatternFilterContext();
        context.setView(view);
        PatternFilterUtils.getFilterParameter(context);
        return PatternFilterUtils.getQFilter(context);
    }

    public static QFilter getSchemeFilter(long projectId) {
        PatternFilterContext context = new PatternFilterContext();
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project");
        context.setProjectObj(projectObj);
        DynamicObject winruleObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project_rule");
        context.setRuleObj(winruleObj);
        return PatternFilterUtils.getQFilter(context);
    }

    private static QFilter getQFilter(PatternFilterContext context) {
        List extFilters;
        Map qfilterMap = FilterGridUtils.getQFilter((String)"pds_extfilter", (String)IPatternFilter.class.getSimpleName());
        context.setQfilter((QFilter)qfilterMap.get("qfilter"));
        if (!StringUtils.isBlank(qfilterMap.get("description"))) {
            context.setDescription(new StringBuilder(qfilterMap.get("description").toString()));
        }
        if (!StringUtils.isBlank(qfilterMap.get("description"))) {
            context.setDescription(new StringBuilder(qfilterMap.get("description").toString()));
        }
        context.setOrderBy(PdsCommonUtils.object2String(qfilterMap.get("orderby"), (String)""));
        if (null != qfilterMap.get("entitykey")) {
            context.setBaseDataType(qfilterMap.get("entitykey").toString());
        }
        if (null != qfilterMap.get("filterfield")) {
            context.getParamMap().put("filterfield", qfilterMap.get("filterfield"));
        }
        if (null != qfilterMap.get("bizobject") && null != context.getProjectObj()) {
            DynamicObject extFilterObj = BusinessDataServiceHelper.loadSingle((Object)PdsCommonUtils.object2Long(qfilterMap.get("billid")), (String)"pds_extfilter");
            ExtFilterUtils.getFieldMatchQFilter((ExtFilterContext)context, (DynamicObject)extFilterObj, (DynamicObject)context.getProjectObj());
        }
        if (null != (extFilters = ExtFilterFactory.getInstance().getExtFilterInstance("pds_extfilter", IPatternFilter.class.getSimpleName())) && extFilters.size() > 0) {
            for (IPatternFilter extFilter : extFilters) {
                extFilter.buildQFilter(context);
            }
        }
        return context.getQfilter();
    }

    public static void setSchemeDefaultValue(IFormView view) {
        QFilter qfilter = PatternFilterUtils.getSchemeFilter(view);
        if (qfilter == null) {
            view.getModel().setValue("scheme", null);
            return;
        }
        String orderBy = "matchfield desc,priority,modifytime desc";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_pattern", (String)"id,number,matchfield,priority,modifytime", (QFilter[])qfilter.toArray(), (String)orderBy);
        if (null == rows || rows.size() == 0) {
            view.getModel().setValue("scheme", null);
            return;
        }
        long schemeId = SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity().getDynamicObject("scheme"));
        if (schemeId == 0L) {
            view.getModel().setValue("scheme", (Object)((DynamicObject)rows.get(0)).getLong("id"));
            return;
        }
        if (rows.stream().noneMatch(row -> schemeId == row.getLong("id"))) {
            view.getModel().setValue("scheme", (Object)((DynamicObject)rows.get(0)).getLong("id"));
        }
    }

    public static void getFilterParameter(PatternFilterContext context) {
        IFormView parentView = context.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        if (PdsCommonUtils.getNotProjectBill().contains(parentView.getEntityId())) {
            context.setProjectObj(parentView.getModel().getDataEntity().getDynamicObject("project"));
        } else {
            context.setProjectObj(parentView.getModel().getDataEntity());
        }
        context.setRuleObj(context.getView().getModel().getDataEntity());
    }
}

