/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.question.clarify;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcQuestionClarifyPurlist
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        DynamicObject billObj = PdsCommonUtils.getBillObjFromContext((ExtPluginContext)context, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj()), (String)"src_question");
        if (context.getBillObj().getBoolean("isclarify") && "6".equals(billObj.getString("publishtype"))) {
            String openstatus = billObj.getString("project.openstatus");
            if (BidOpenStatusEnums.BIZOPEN.getValue().equals(openstatus) || BidOpenStatusEnums.OPEN.getValue().equals(openstatus)) {
                this.purlistHandle(context);
            }
        }
    }

    public void purlistHandle(ExtPluginContext context) {
        Map<Long, DynamicObject> entryIdMap;
        DynamicObject billObj = context.getBillObj();
        DynamicObject[] purlistObjs = this.getPurlistObjs(billObj, entryIdMap = this.getChgEntryIdMap(billObj));
        if (null != purlistObjs && purlistObjs.length > 0) {
            this.updatePurlist(billObj, purlistObjs, entryIdMap);
        }
    }

    public Map<Long, DynamicObject> getChgEntryIdMap(DynamicObject billObj) {
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        return rows.stream().filter(e -> e.getBoolean("isnew")).collect(Collectors.toMap(obj -> Optional.ofNullable(obj.getString("srcentryid")).map(Long::parseLong).orElse(0L), obj -> obj));
    }

    public DynamicObject[] getPurlistObjs(DynamicObject billObj, Map<Long, DynamicObject> entryIdMap) {
        long projectId = billObj.getLong("project.id");
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("id", "in", entryIdMap.keySet());
        String seelctFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)false);
        return BusinessDataServiceHelper.load((String)"src_purlistf7", (String)seelctFields, (QFilter[])qfilter.toArray());
    }

    public void updatePurlist(DynamicObject billObj, DynamicObject[] purlistObjs, Map<Long, DynamicObject> entryIdMap) {
        QFilter qfilter = new QFilter("id", "=", (Object)purlistObjs[0].getLong("project.id"));
        String selectFields = "currency.id curr,currency.amtprecision amtprecision,taxtype,decisiontype";
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_projectf7", (String)selectFields, (QFilter[])qfilter.toArray());
        List properties = null;
        for (DynamicObject purlistObj : purlistObjs) {
            DynamicObject newObj = entryIdMap.get(purlistObj.getLong("id"));
            if (!Objects.nonNull(newObj)) continue;
            if (null == properties) {
                properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)newObj);
            }
            this.writebackFirstValue(purlistObj);
            this.setPurlistValue(purlistObj, newObj, properties);
            this.calcPriceAndAmount(projectObj, purlistObj, newObj);
            this.writebackClarifyEntry(purlistObj, newObj);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])purlistObjs);
        PdsCommonUtils.saveDynamicObjects((DynamicObject)billObj);
    }

    public void calcPriceAndAmount(DynamicObject projectObj, DynamicObject purlistObj, DynamicObject newPurlistObj) {
        if ("2".equals(projectObj.getString("decisiontype"))) {
            this.calcPriceAndAmountByAmount(projectObj, purlistObj);
        } else if (purlistObj.getBigDecimal("qty").compareTo(newPurlistObj.getBigDecimal("qty")) != 0) {
            this.calcPriceAndAmountByQty(projectObj, purlistObj);
        } else {
            this.calcPriceAndAmountByPrice(projectObj, purlistObj);
        }
    }

    public void calcPriceAndAmountByQty(DynamicObject projectObj, DynamicObject purlistObj) {
        Cal4DynamicObj.calEntryByQty((DynamicObject)projectObj, (DynamicObject)purlistObj);
    }

    public void calcPriceAndAmountByAmount(DynamicObject projectObj, DynamicObject purlistObj) {
        if ("2".equals(projectObj.getString("taxtype"))) {
            Cal4DynamicObj.calEntryByAmount((DynamicObject)projectObj, (DynamicObject)purlistObj);
        } else {
            Cal4DynamicObj.calEntryByTaxAmount((DynamicObject)projectObj, (DynamicObject)purlistObj);
        }
    }

    public void calcPriceAndAmountByPrice(DynamicObject projectObj, DynamicObject purlistObj) {
        if ("2".equals(projectObj.getString("taxtype"))) {
            Cal4DynamicObj.calEntryByPrice((DynamicObject)projectObj, (DynamicObject)purlistObj);
        } else {
            Cal4DynamicObj.calEntryByTaxPrice((DynamicObject)projectObj, (DynamicObject)purlistObj);
        }
        int price_uom = purlistObj.getInt("price_uom");
        if (price_uom > 0) {
            int amtprecision = projectObj.getInt("amtprecision");
            BigDecimal amount = purlistObj.getBigDecimal("amount").divide(new BigDecimal(price_uom), amtprecision, RoundingMode.HALF_DOWN);
            BigDecimal taxAmount = purlistObj.getBigDecimal("taxamount").divide(new BigDecimal(price_uom), amtprecision, RoundingMode.HALF_DOWN);
            purlistObj.set("amount", (Object)amount);
            purlistObj.set("taxamount", (Object)taxAmount);
        }
    }

    public void setPurlistValue(DynamicObject purlistObj, DynamicObject newObj, List<String> properties) {
        for (String fieldName : properties) {
            if (!fieldName.contains("_new")) continue;
            purlistObj.set(fieldName.substring(0, fieldName.lastIndexOf(95) <= 0 ? fieldName.length() : fieldName.lastIndexOf(95)), newObj.get(fieldName));
        }
    }

    public void writebackClarifyEntry(DynamicObject purlistObj, DynamicObject row) {
        row.set("price_new", purlistObj.get("price"));
        row.set("taxprice_new", purlistObj.get("taxprice"));
        row.set("amount_new", purlistObj.get("amount"));
        row.set("taxamount_new", purlistObj.get("taxamount"));
    }

    public void writebackFirstValue(DynamicObject purlistObj) {
        String stuats = purlistObj.getString("entrystatus");
        if ("A".equals(stuats) || "B".equals(stuats)) {
            return;
        }
        if (purlistObj.getBigDecimal("firstprice").compareTo(BigDecimal.ZERO) > 0 || purlistObj.getBigDecimal("firsttaxprice").compareTo(BigDecimal.ZERO) > 0 || purlistObj.getBigDecimal("firstamount").compareTo(BigDecimal.ZERO) > 0 || purlistObj.getBigDecimal("firsttaxamount").compareTo(BigDecimal.ZERO) > 0) {
            return;
        }
        purlistObj.set("firstprice", purlistObj.get("price"));
        purlistObj.set("firsttaxprice", purlistObj.get("taxprice"));
        purlistObj.set("firstamount", purlistObj.get("amount"));
        purlistObj.set("firsttaxamount", purlistObj.get("taxamount"));
    }
}

