/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.question.reply;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.question.IPdsQuestionHandler;
import kd.scm.pds.common.question.PdsQuestionContext;
import kd.scm.pds.common.question.PdsQuestionUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcQuestionReplyAfterSave
implements IPdsQuestionHandler {
    private static final long serialVersionUID = 1L;

    public void process(PdsQuestionContext context) {
        List billIds = PdsQuestionUtils.getBillIdsFromCustomParamMap((IFormView)context.getView());
        if (billIds.size() <= 1) {
            return;
        }
        billIds.remove(0);
        this.otherBillReplyInfoHandle(context, billIds);
        this.otherBillAttachmentHandle(context, billIds);
    }

    protected void otherBillReplyInfoHandle(PdsQuestionContext context, List<Long> billIds) {
        QFilter qfilters = new QFilter("id", "in", billIds);
        String selectFields = "replycontent,responder,replytime,srcbillid";
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)context.getView().getEntityId(), (String)selectFields, (QFilter[])qfilters.toArray());
        if (objs.length == 0) {
            return;
        }
        for (DynamicObject obj : objs) {
            obj.set("replycontent", context.getView().getModel().getValue("replycontent"));
            obj.set("responder", context.getView().getModel().getValue("responder"));
            obj.set("replytime", context.getView().getModel().getValue("replytime"));
            obj.set("srcbillid", context.getView().getModel().getValue("srcbillid"));
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])objs);
    }

    protected void otherBillAttachmentHandle(PdsQuestionContext context, List<Long> billIds) {
        String selectfields = DynamicObjectUtil.getSelectfields((String)"bos_attachment", (boolean)false);
        QFilter qFilter = new QFilter("finterid", "=", (Object)context.getView().getModel().getDataEntity().getPkValue().toString());
        qFilter.and("fattachmentpanel", "=", (Object)"replyattach");
        qFilter.and("fbilltype", "=", (Object)"src_question");
        DynamicObject attachmentObject = BusinessDataServiceHelper.loadSingle((String)"bos_attachment", (String)selectfields, (QFilter[])qFilter.toArray());
        if (attachmentObject == null) {
            return;
        }
        QFilter qFilter2 = new QFilter("finterid", "in", billIds.stream().map(String::valueOf).collect(Collectors.toSet()));
        qFilter2.and("fattachmentpanel", "=", (Object)"replyattach");
        qFilter2.and("fbilltype", "=", (Object)"src_question");
        DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])new QFilter[]{qFilter2});
        ArrayList<DynamicObject> cloneAttachments = new ArrayList<DynamicObject>(billIds.size());
        for (Long billId : billIds) {
            DynamicObject cloneAttachment = (DynamicObject)OrmUtils.clone((IDataEntityBase)attachmentObject, (boolean)true, (boolean)true);
            PdsCommonUtils.setPrimaryKey((DynamicObject)cloneAttachment);
            cloneAttachment.set("finterid", (Object)billId);
            cloneAttachments.add(cloneAttachment);
        }
        PdsCommonUtils.saveDynamicObjects(cloneAttachments);
    }
}

