/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.recommend;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.util.PdsCalculateUtils;
import kd.scm.src.common.recommend.ISrcRecommendSupplier;

public class SrcRecommendSupplierCalcByAmount
implements ISrcRecommendSupplier {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.calcRankMap(context);
    }

    protected void calcRankMap(ExtPluginContext context) {
        DynamicObject projectF7 = context.getProjectObj().getDynamicObject("projectf7");
        String manageType = projectF7.getString("managetype");
        String taxType = projectF7.getString("taxtype");
        String valueField = "2".equals(taxType) ? "locamount" : "loctaxamount";
        DynamicObject ruleObj = QueryServiceHelper.queryOne((String)"src_project_rule", (String)"scheme.ranktype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)context.getProjectId())});
        String rankType = ruleObj.getString("scheme.ranktype");
        int selectNum = projectF7.getInt("biderqty") > 0 ? projectF7.getInt("biderqty") : 9999;
        QFilter qFilter = new QFilter("project", "=", (Object)context.getProjectId());
        qFilter.and("isdiscarded", "=", (Object)"0");
        qFilter.and("supplier", ">", (Object)0);
        qFilter.and(new QFilter("entrystatus", "=", (Object)"B").or("entrystatus", "=", (Object)"C"));
        qFilter.and(new QFilter("locamount", ">", (Object)0).or("loctaxamount", ">", (Object)0));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"package.id,suppliertype,supplier.id,locamount,loctaxamount", (QFilter[])qFilter.toArray());
        if (rows.size() == 0) {
            context.setMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u91c7\u8d2d\u6e05\u5355\uff0c\u53ef\u80fd\u662f\u4f9b\u5e94\u5546\u672a\u62a5\u4ef7\u3002", (String)"SrcRecommendSupplierCalcByAmount_0", (String)"scm-src-common", (Object[])new Object[0]));
            context.setSucced(false);
            return;
        }
        HashMap rankMap = new HashMap();
        if ("2".equals(manageType)) {
            Map<String, List<DynamicObject>> pacakgeMap = rows.stream().collect(Collectors.groupingBy(e -> String.valueOf(e.getLong("package.id"))));
            for (Map.Entry<String, List<DynamicObject>> entry : pacakgeMap.entrySet()) {
                Map<String, List<DynamicObject>> groupMap = entry.getValue().stream().collect(Collectors.groupingBy(e -> String.valueOf(e.getLong("package.id")) + '_' + String.valueOf(e.getLong("supplier.id"))));
                Map rankMapTemp = PdsCalculateUtils.getRankMapFromGroupMap(groupMap, (String)valueField, (boolean)"2".equals(rankType), (int)selectNum);
                rankMap.putAll(rankMapTemp);
            }
        } else {
            Map<String, List<DynamicObject>> groupMap = rows.stream().collect(Collectors.groupingBy(e -> String.valueOf(e.getLong("supplier.id"))));
            Map rankMapTemp = PdsCalculateUtils.getRankMapFromGroupMap(groupMap, (String)valueField, (boolean)"2".equals(rankType), (int)selectNum);
            rankMap.putAll(rankMapTemp);
        }
        context.setParamMap2(rankMap);
    }
}

